/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.regex.Pattern;
import org.jboss.as.controller.ExpressionResolverExtension;
import org.jboss.as.controller.ExpressionResolverImpl;
import org.jboss.as.controller.OperationClientException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;

@FunctionalInterface
public interface ExpressionResolver {
    public static final Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");
    public static final ExpressionResolver SIMPLE;
    public static final ExpressionResolver TEST_RESOLVER;
    public static final ExpressionResolver SIMPLE_LENIENT;
    public static final ExpressionResolver REJECTING;

    public ModelNode resolveExpressions(ModelNode var1) throws OperationFailedException;

    default public ModelNode resolveExpressions(ModelNode node, OperationContext context) throws OperationFailedException {
        return this.resolveExpressions(node);
    }

    static {
        TEST_RESOLVER = SIMPLE = new ExpressionResolverImpl();
        SIMPLE_LENIENT = new ExpressionResolverImpl(true);
        REJECTING = new ExpressionResolverImpl(){

            @Override
            protected void resolvePluggableExpression(ModelNode node, OperationContext context) throws OperationFailedException {
                String expression = node.asString();
                if (EXPRESSION_PATTERN.matcher(expression).matches()) {
                    throw ControllerLogger.ROOT_LOGGER.illegalUnresolvedModel(expression);
                }
                node.set(expression);
            }
        };
    }

    public static class ExpressionResolutionServerException
    extends RuntimeException {
        public ExpressionResolutionServerException(String msg) {
            super(msg);
        }

        public ExpressionResolutionServerException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static class ExpressionResolutionUserException
    extends RuntimeException
    implements OperationClientException {
        public ExpressionResolutionUserException(String msg) {
            super(msg);
        }

        public ExpressionResolutionUserException(String msg, Throwable cause) {
            super(msg, cause);
        }

        @Override
        public ModelNode getFailureDescription() {
            return new ModelNode(this.getLocalizedMessage());
        }
    }

    public static interface ResolverExtensionRegistry {
        public void addResolverExtension(ExpressionResolverExtension var1);

        public void removeResolverExtension(ExpressionResolverExtension var1);
    }
}

