/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.event.logger;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.wildfly.event.logger.AsyncEventLogger;
import org.wildfly.event.logger.EventWriter;
import org.wildfly.event.logger.JsonEventFormatter;
import org.wildfly.event.logger.StandardEventLogger;
import org.wildfly.event.logger.StdoutEventWriter;

public interface EventLogger {
    public static EventLogger createLogger(String eventSource) {
        return new StandardEventLogger(eventSource, StdoutEventWriter.of(JsonEventFormatter.builder().build()));
    }

    public static EventLogger createLogger(String eventSource, EventWriter writer) {
        return new StandardEventLogger(eventSource, writer);
    }

    public static EventLogger createAsyncLogger(String eventSource, Executor executor) {
        return new AsyncEventLogger(eventSource, StdoutEventWriter.of(JsonEventFormatter.builder().build()), executor);
    }

    public static EventLogger createAsyncLogger(String eventSource, EventWriter writer, Executor executor) {
        return new AsyncEventLogger(eventSource, writer, executor);
    }

    public EventLogger log(Map<String, Object> var1);

    public EventLogger log(Supplier<Map<String, Object>> var1);

    public String getEventSource();
}

