/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extension.messaging.activemq.BroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.JGroupsBroadcastGroupAdd;
import org.wildfly.extension.messaging.activemq.SocketBroadcastGroupAdd;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.wildfly.extension.messaging.activemq.shallow.ShallowResourceAdd;

public class BroadcastGroupAdd
extends ShallowResourceAdd {
    public static final BroadcastGroupAdd INSTANCE = new BroadcastGroupAdd(false);
    public static final BroadcastGroupAdd LEGACY_INSTANCE = new BroadcastGroupAdd(true);
    private final boolean isLegacyCall;

    private BroadcastGroupAdd(boolean isLegacyCall) {
        super(BroadcastGroupDefinition.ATTRIBUTES);
        this.isLegacyCall = isLegacyCall;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        CommonAttributes.renameChannelToCluster(operation);
        if (!this.isLegacyCall) {
            Object addHandler;
            ModelNode op = operation.clone();
            PathAddress target = context.getCurrentAddress().getParent();
            if (operation.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName())) {
                target = target.append("jgroups-broadcast-group", context.getCurrentAddressValue());
                addHandler = JGroupsBroadcastGroupAdd.LEGACY_INSTANCE;
            } else {
                target = target.append("socket-broadcast-group", context.getCurrentAddressValue());
                addHandler = SocketBroadcastGroupAdd.LEGACY_INSTANCE;
            }
            op.get("address").set(target.toModelNode());
            context.addStep(op, (OperationStepHandler)addHandler, OperationContext.Stage.MODEL, true);
        }
        super.execute(context, operation);
    }

    static void addBroadcastGroupConfigs(OperationContext context, List<BroadcastGroupConfiguration> configs, Set<String> connectors, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("jgroups-broadcast-group")) {
            for (Property prop : model.get("jgroups-broadcast-group").asPropertyList()) {
                configs.add(BroadcastGroupAdd.createBroadcastGroupConfiguration(context, connectors, prop.getName(), prop.getValue()));
            }
        }
        if (model.hasDefined("socket-broadcast-group")) {
            for (Property prop : model.get("socket-broadcast-group").asPropertyList()) {
                configs.add(BroadcastGroupAdd.createBroadcastGroupConfiguration(context, connectors, prop.getName(), prop.getValue()));
            }
        }
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(OperationContext context, Set<String> connectors, String name, ModelNode model) throws OperationFailedException {
        long broadcastPeriod = BroadcastGroupDefinition.BROADCAST_PERIOD.resolveModelAttribute(context, model).asLong();
        ArrayList<String> connectorRefs = new ArrayList<String>();
        if (model.hasDefined("connectors")) {
            for (ModelNode ref : model.get("connectors").asList()) {
                String refName = ref.asString();
                if (!connectors.contains(refName)) {
                    throw MessagingLogger.ROOT_LOGGER.wrongConnectorRefInBroadCastGroup(name, refName, connectors);
                }
                connectorRefs.add(refName);
            }
        }
        return new BroadcastGroupConfiguration().setName(name).setBroadcastPeriod(broadcastPeriod).setConnectorInfos(connectorRefs);
    }
}

