/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.PathTemplateMatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Deque;
import java.util.function.Function;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.marshalling.ContextClassResolver;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.httpclient.common.HttpServerHelper;
import org.wildfly.httpclient.common.NoFlushByteOutput;
import org.wildfly.httpclient.naming.HttpNamingClientMessages;

public class HttpRemoteNamingService {
    private static final String UTF_8 = "UTF-8";
    private static final String LOOKUP = "/v1/lookup/{name}";
    private static final String LOOKUPLINK = "/v1/lookuplink/{name}";
    private static final String BIND = "/v1/bind/{name}";
    private static final String REBIND = "/v1/rebind/{name}";
    private static final String UNBIND = "/v1/unbind/{name}";
    private static final String DESTROY_SUBCONTEXT = "/v1/dest-subctx/{name}";
    private static final String LIST = "/v1/list/{name}";
    private static final String LIST_BINDINGS = "/v1/list-bindings/{name}";
    private static final String RENAME = "/v1/rename/{name}";
    private static final String CREATE_SUBCONTEXT = "/v1/create-subcontext/{name}";
    private static final MarshallerFactory MARSHALLER_FACTORY = new RiverMarshallerFactory();
    private final Context localContext;
    private final Function<String, Boolean> classResolverFilter;

    public HttpRemoteNamingService(Context localContext) {
        this(localContext, null);
    }

    public HttpRemoteNamingService(Context localContext, Function<String, Boolean> classResolverFilter) {
        this.localContext = localContext;
        this.classResolverFilter = classResolverFilter;
    }

    public HttpHandler createHandler() {
        RoutingHandler routingHandler = new RoutingHandler();
        routingHandler.add(Methods.POST, LOOKUP, (HttpHandler)new LookupHandler());
        routingHandler.add(Methods.GET, LOOKUPLINK, (HttpHandler)new LookupLinkHandler());
        routingHandler.add(Methods.PUT, BIND, (HttpHandler)new BindHandler());
        routingHandler.add(Methods.PATCH, REBIND, (HttpHandler)new RebindHandler());
        routingHandler.add(Methods.DELETE, UNBIND, (HttpHandler)new UnbindHandler());
        routingHandler.add(Methods.DELETE, DESTROY_SUBCONTEXT, (HttpHandler)new DestroySubcontextHandler());
        routingHandler.add(Methods.GET, LIST, (HttpHandler)new ListHandler());
        routingHandler.add(Methods.GET, LIST_BINDINGS, (HttpHandler)new ListBindingsHandler());
        routingHandler.add(Methods.PATCH, RENAME, (HttpHandler)new RenameHandler());
        routingHandler.add(Methods.PUT, CREATE_SUBCONTEXT, (HttpHandler)new CreateSubContextHandler());
        return new BlockingHandler(new ElytronIdentityHandler(routingHandler));
    }

    private static void doMarshall(HttpServerExchange exchange, Object result) throws IOException {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/x-wf-jndi-jbmar-value;version=1");
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setVersion(2);
        Marshaller marshaller = MARSHALLER_FACTORY.createMarshaller(marshallingConfiguration);
        marshaller.start(new NoFlushByteOutput(Marshalling.createByteOutput(exchange.getOutputStream())));
        marshaller.writeObject(result);
        marshaller.finish();
        marshaller.flush();
    }

    public static void sendException(HttpServerExchange exchange, int status, Throwable e) throws IOException {
        HttpServerHelper.sendException(exchange, status, e);
    }

    private static class FilterClassResolver
    extends ContextClassResolver {
        private final Function<String, Boolean> filter;

        private FilterClassResolver(Function<String, Boolean> filter) {
            this.filter = filter;
        }

        @Override
        public Class<?> resolveClass(Unmarshaller unmarshaller, String name, long serialVersionUID) throws IOException, ClassNotFoundException {
            this.checkFilter(name);
            return super.resolveClass(unmarshaller, name, serialVersionUID);
        }

        @Override
        public Class<?> resolveProxyClass(Unmarshaller unmarshaller, String[] interfaces) throws IOException, ClassNotFoundException {
            for (String name : interfaces) {
                this.checkFilter(name);
            }
            return super.resolveProxyClass(unmarshaller, interfaces);
        }

        private void checkFilter(String className) throws InvalidClassException {
            if (this.filter.apply(className) != Boolean.TRUE) {
                throw HttpNamingClientMessages.MESSAGES.cannotResolveFilteredClass(className);
            }
        }
    }

    private class BindHandler
    extends NameHandler {
        private BindHandler() {
        }

        @Override
        protected final Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            ContentType contentType = ContentType.parse(exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE));
            if (contentType == null || !contentType.getType().equals("application/x-wf-jndi-jbmar-value") || contentType.getVersion() != 1) {
                exchange.setStatusCode(400);
                exchange.endExchange();
                return null;
            }
            MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
            marshallingConfiguration.setVersion(2);
            if (HttpRemoteNamingService.this.classResolverFilter != null) {
                marshallingConfiguration.setClassResolver(new FilterClassResolver(HttpRemoteNamingService.this.classResolverFilter));
            }
            try (InputStream inputStream = exchange.getInputStream();){
                Unmarshaller unmarshaller = MARSHALLER_FACTORY.createUnmarshaller(marshallingConfiguration);
                unmarshaller.start(new InputStreamByteInput(inputStream));
                Object object = unmarshaller.readObject();
                unmarshaller.finish();
                this.doOperation(name, object);
            }
            catch (Exception e) {
                if (e instanceof NamingException) {
                    throw (NamingException)e;
                }
                NamingException nm = new NamingException(e.getMessage());
                nm.initCause(e);
                throw nm;
            }
            return null;
        }

        protected void doOperation(String name, Object object) throws NamingException {
            HttpRemoteNamingService.this.localContext.bind(name, object);
        }
    }

    private class RebindHandler
    extends BindHandler {
        private RebindHandler() {
        }

        @Override
        protected void doOperation(String name, Object object) throws NamingException {
            HttpRemoteNamingService.this.localContext.rebind(name, object);
        }
    }

    private class ListHandler
    extends NameHandler {
        private ListHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return HttpRemoteNamingService.this.localContext.list(name);
        }
    }

    private class DestroySubcontextHandler
    extends NameHandler {
        private DestroySubcontextHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            HttpRemoteNamingService.this.localContext.destroySubcontext(name);
            return null;
        }
    }

    private class RenameHandler
    extends NameHandler {
        private RenameHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            Deque<String> newName = exchange.getQueryParameters().get("new");
            if (newName == null || newName.isEmpty()) {
                exchange.setStatusCode(400);
                exchange.endExchange();
                return null;
            }
            try {
                String nn = URLDecoder.decode(newName.getFirst(), HttpRemoteNamingService.UTF_8);
                HttpRemoteNamingService.this.localContext.rename(name, nn);
                return null;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ListBindingsHandler
    extends NameHandler {
        private ListBindingsHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return HttpRemoteNamingService.this.localContext.listBindings(name);
        }
    }

    private class UnbindHandler
    extends NameHandler {
        private UnbindHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            HttpRemoteNamingService.this.localContext.unbind(name);
            return null;
        }
    }

    private class CreateSubContextHandler
    extends NameHandler {
        private CreateSubContextHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return HttpRemoteNamingService.this.localContext.createSubcontext(name);
        }
    }

    private final class LookupLinkHandler
    extends NameHandler {
        private LookupLinkHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return HttpRemoteNamingService.this.localContext.lookupLink(name);
        }
    }

    private final class LookupHandler
    extends NameHandler {
        private LookupHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return HttpRemoteNamingService.this.localContext.lookup(name);
        }
    }

    private abstract class NameHandler
    implements HttpHandler {
        private NameHandler() {
        }

        @Override
        public final void handleRequest(HttpServerExchange exchange) throws Exception {
            PathTemplateMatch params = exchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY);
            String name = URLDecoder.decode(params.getParameters().get("name"), HttpRemoteNamingService.UTF_8);
            try {
                Object result = this.doOperation(exchange, name);
                if (exchange.isComplete()) {
                    return;
                }
                if (result == null) {
                    exchange.setStatusCode(200);
                } else if (result instanceof Context) {
                    exchange.setStatusCode(204);
                } else {
                    HttpRemoteNamingService.doMarshall(exchange, result);
                }
            }
            catch (Throwable e) {
                HttpRemoteNamingService.sendException(exchange, 500, e);
            }
        }

        protected abstract Object doOperation(HttpServerExchange var1, String var2) throws NamingException;
    }
}

