/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jsapi;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.ResourceLocatorInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.jsapi.MethodMetaData;
import org.jboss.resteasy.jsapi.i18n.LogMessages;
import org.jboss.resteasy.jsapi.i18n.Messages;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.util.GetRestful;

public class ServiceRegistry {
    private static final long serialVersionUID = -1985015444704126795L;
    private ResourceMethodRegistry registry;
    private ResteasyProviderFactory providerFactory;
    private ServiceRegistry parent;
    private ArrayList<MethodMetaData> methods;
    private ArrayList<ServiceRegistry> locators;
    private ResourceLocatorInvoker invoker;
    private String uri;
    private String functionPrefix;

    public ServiceRegistry getParent() {
        return this.parent;
    }

    public ServiceRegistry(ServiceRegistry parent, ResourceMethodRegistry registry, ResteasyProviderFactory providerFactory, ResourceLocatorInvoker invoker) throws Exception {
        this.parent = parent;
        this.registry = registry;
        this.providerFactory = providerFactory;
        this.invoker = invoker;
        if (invoker != null) {
            Method method = invoker.getMethod();
            ResourceLocator resourceLocator = MethodMetaData.getResourceLocator((ResourceInvoker)invoker);
            String methodPathVal = resourceLocator.getPath();
            String classPathVal = resourceLocator.getResourceClass().getPath();
            this.uri = MethodMetaData.appendURIFragments(parent, classPathVal, methodPathVal);
            this.functionPrefix = parent.isRoot() ? method.getDeclaringClass().getSimpleName() + "." + method.getName() : parent.getFunctionPrefix() + "." + method.getName();
        }
        this.scanRegistry();
    }

    private void scanRegistry() throws Exception {
        this.methods = new ArrayList();
        this.locators = new ArrayList();
        for (Map.Entry entry : this.registry.getBounded().entrySet()) {
            List invokers = (List)entry.getValue();
            for (ResourceInvoker invoker : invokers) {
                Class[] locatorResourceTypes;
                if (invoker instanceof ResourceMethodInvoker) {
                    this.methods.add(new MethodMetaData(this, (ResourceMethodInvoker)invoker));
                    continue;
                }
                if (!(invoker instanceof ResourceLocatorInvoker)) continue;
                ResourceLocatorInvoker locator = (ResourceLocatorInvoker)invoker;
                Method method = locator.getMethod();
                Class<?> locatorType = method.getReturnType();
                for (Class locatorResourceType : locatorResourceTypes = GetRestful.getSubResourceClasses(locatorType)) {
                    if (locatorResourceType == null) {
                        if (!LogMessages.LOGGER.isEnabled(Logger.Level.WARN)) continue;
                        LogMessages.LOGGER.warn(Messages.MESSAGES.impossibleToGenerateJsapi(method.getDeclaringClass().getName(), method.getName()));
                        continue;
                    }
                    ResourceMethodRegistry locatorRegistry = new ResourceMethodRegistry(this.providerFactory);
                    locatorRegistry.addResourceFactory(null, null, locatorResourceType);
                    this.locators.add(new ServiceRegistry(this, locatorRegistry, this.providerFactory, locator));
                }
            }
        }
    }

    public List<MethodMetaData> getMethodMetaData() {
        return this.methods;
    }

    public List<ServiceRegistry> getLocators() {
        return this.locators;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String getFunctionPrefix() {
        return this.functionPrefix;
    }

    public void collectResourceMethodsUntilRoot(List<Method> methods) {
        if (this.isRoot()) {
            return;
        }
        methods.add(this.invoker.getMethod());
        this.parent.collectResourceMethodsUntilRoot(methods);
    }
}

