/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;

public class XSiteStateTransferFinishReceiveCommand
extends XSiteReplicateCommand<Void> {
    public static final byte COMMAND_ID = 107;
    private String siteName;

    public XSiteStateTransferFinishReceiveCommand() {
        super((byte)107, null);
    }

    public XSiteStateTransferFinishReceiveCommand(ByteString cacheName) {
        this(cacheName, null);
    }

    public XSiteStateTransferFinishReceiveCommand(ByteString cacheName, String siteName) {
        super((byte)107, cacheName);
        this.siteName = siteName;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) {
        this.invokeLocal(registry.getXSiteStateTransferManager().running().getStateConsumer());
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> performInLocalSite(BackupReceiver receiver, boolean preserveOrder) {
        assert (!preserveOrder);
        return receiver.handleEndReceivingStateTransfer(this);
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString((String)this.siteName, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.siteName = MarshallUtil.unmarshallString((ObjectInput)input);
    }

    public static XSiteStateTransferFinishReceiveCommand copyForCache(XSiteStateTransferFinishReceiveCommand command, ByteString cacheName) {
        if (!command.cacheName.equals(cacheName)) {
            return new XSiteStateTransferFinishReceiveCommand(cacheName, command.originSite);
        }
        command.siteName = command.originSite;
        return command;
    }

    @Override
    public String toString() {
        return "XSiteStateTransferFinishReceiveCommand{siteName='" + this.siteName + '\'' + ", cacheName=" + this.cacheName + '}';
    }

    public void invokeLocal(XSiteStateConsumer consumer) {
        consumer.endStateTransfer(this.siteName);
    }
}

