/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import org.jboss.as.ee.component.ComponentView;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class ComponentTypeIdentityInterceptorFactory
implements InterceptorFactory {
    public static final ComponentTypeIdentityInterceptorFactory INSTANCE = new ComponentTypeIdentityInterceptorFactory();

    private ComponentTypeIdentityInterceptorFactory() {
    }

    public Interceptor create(InterceptorFactoryContext context) {
        ComponentView componentView = (ComponentView)context.getContextData().get(ComponentView.class);
        return new ProxyTypeEqualsInterceptor(componentView);
    }

    private static class ProxyTypeEqualsInterceptor
    implements Interceptor {
        private final ComponentView componentView;

        public ProxyTypeEqualsInterceptor(ComponentView componentView) {
            this.componentView = componentView;
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            if (context.getMethod().getName().equals("equals") || context.getMethod().getName().equals("isIdentical")) {
                Object other = context.getParameters()[0];
                if (other == null) {
                    return false;
                }
                Class proxyType = this.componentView.getProxyClass();
                return proxyType.isAssignableFrom(other.getClass());
            }
            if (context.getMethod().getName().equals("hashCode")) {
                return this.componentView.hashCode();
            }
            return context.proceed();
        }
    }
}

