/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.BroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.JGroupsBroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class BroadcastGroupWriteAttributeHandler
extends ReloadRequiredWriteAttributeHandler {
    public static final BroadcastGroupWriteAttributeHandler INSTANCE = new BroadcastGroupWriteAttributeHandler(MessagingExtension.BROADCAST_GROUP_PATH, BroadcastGroupDefinition.ATTRIBUTES);
    public static final BroadcastGroupWriteAttributeHandler JGROUP_INSTANCE = new BroadcastGroupWriteAttributeHandler(MessagingExtension.JGROUPS_BROADCAST_GROUP_PATH, JGroupsBroadcastGroupDefinition.ATTRIBUTES);
    public static final BroadcastGroupWriteAttributeHandler SOCKET_INSTANCE = new BroadcastGroupWriteAttributeHandler(MessagingExtension.SOCKET_BROADCAST_GROUP_PATH, JGroupsBroadcastGroupDefinition.ATTRIBUTES);
    private final PathElement path;

    private BroadcastGroupWriteAttributeHandler(PathElement path, AttributeDefinition ... definitions) {
        super(definitions);
        this.path = path;
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        if (attributeName.equals("connectors")) {
            this.validateConnectors(context, operation, newValue);
        }
        super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
    }

    void validateConnectors(OperationContext context, ModelNode operation, ModelNode connectorRefs) throws OperationFailedException {
        Set<String> availableConnectors = BroadcastGroupWriteAttributeHandler.getAvailableConnectors(context, operation);
        List operationAddress = operation.get("address").asList();
        String broadCastGroup = ((ModelNode)operationAddress.get(operationAddress.size() - 1)).get(this.path.getKey()).asString();
        if (connectorRefs.isDefined()) {
            for (ModelNode connectorRef : connectorRefs.asList()) {
                String connectorName = connectorRef.asString();
                if (availableConnectors.contains(connectorName)) continue;
                throw MessagingLogger.ROOT_LOGGER.wrongConnectorRefInBroadCastGroup(broadCastGroup, connectorName, availableConnectors);
            }
        }
    }

    private static Set<String> getAvailableConnectors(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress active = MessagingServices.getActiveMQServerPathAddress(address);
        HashSet<String> availableConnectors = new HashSet<String>();
        Resource subsystemResource = context.readResourceFromRoot(active.getParent(), false);
        availableConnectors.addAll(subsystemResource.getChildrenNames("remote-connector"));
        Resource activeMQServerResource = context.readResourceFromRoot(active, false);
        availableConnectors.addAll(activeMQServerResource.getChildrenNames("http-connector"));
        availableConnectors.addAll(activeMQServerResource.getChildrenNames("in-vm-connector"));
        availableConnectors.addAll(activeMQServerResource.getChildrenNames("remote-connector"));
        availableConnectors.addAll(activeMQServerResource.getChildrenNames("connector"));
        return availableConnectors;
    }
}

