/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry.deployment;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.weld.WeldCapability;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.extension.opentelemetry.OpenTelemetryHolder;
import org.wildfly.extension.opentelemetry.api.OpenTelemetryCdiExtension;
import org.wildfly.extension.opentelemetry.deployment.OpenTelemetryExtensionLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class OpenTelemetrySubsystemDeploymentProcessor
implements DeploymentUnitProcessor {
    private final OpenTelemetryHolder holder;

    public OpenTelemetrySubsystemDeploymentProcessor(OpenTelemetryHolder holder) {
        this.holder = holder;
    }

    public void deploy(DeploymentPhaseContext deploymentPhaseContext) throws DeploymentUnitProcessingException {
        OpenTelemetryExtensionLogger.OTEL_LOGGER.processingDeployment();
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        try {
            WeldCapability weldCapability = (WeldCapability)((CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT)).getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
            if (!weldCapability.isPartOfWeldDeployment(deploymentUnit)) {
                OpenTelemetryExtensionLogger.OTEL_LOGGER.noCdiDeployment();
                return;
            }
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw OpenTelemetryExtensionLogger.OTEL_LOGGER.deploymentRequiresCapability(deploymentPhaseContext.getDeploymentUnit().getName(), "org.wildfly.weld");
        }
        this.setupOtelCdiBeans(deploymentPhaseContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupOtelCdiBeans(DeploymentPhaseContext deploymentPhaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        ClassLoader initialCl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        ModuleClassLoader moduleCL = ((Module)deploymentUnit.getAttachment(Attachments.MODULE)).getClassLoader();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)moduleCL);
            String serviceName = this.holder.config.serviceName != null ? this.holder.config.serviceName : this.getServiceName(deploymentUnit);
            OpenTelemetry openTelemetry = OpenTelemetryCdiExtension.registerApplicationOpenTelemetryBean((ClassLoader)moduleCL, (OpenTelemetry)this.holder.getOpenTelemetry());
            OpenTelemetryCdiExtension.registerApplicationTracer((ClassLoader)moduleCL, (Tracer)openTelemetry.getTracer(serviceName));
            OpenTelemetryExtensionLogger.OTEL_LOGGER.registeringTracer(serviceName);
        }
        catch (IllegalArgumentException | SecurityException ex) {
            OpenTelemetryExtensionLogger.OTEL_LOGGER.errorResolvingTracer(ex);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)initialCl);
        }
    }

    private String getServiceName(DeploymentUnit deploymentUnit) {
        JBossWebMetaData jbossWebMetaData = this.getJBossWebMetaData(deploymentUnit);
        String serviceName = null;
        if (null == jbossWebMetaData) {
            serviceName = "";
        } else {
            if (jbossWebMetaData.getContextParams() != null) {
                for (ParamValueMetaData param : jbossWebMetaData.getContextParams()) {
                    if (!"service-name".equals(param.getParamName())) continue;
                    serviceName = param.getParamValue();
                }
            }
            if (null == serviceName || serviceName.isEmpty()) {
                serviceName = null != deploymentUnit.getParent() ? deploymentUnit.getParent().getServiceName().getSimpleName() + "!" + deploymentUnit.getServiceName().getSimpleName() : deploymentUnit.getServiceName().getSimpleName();
                OpenTelemetryExtensionLogger.OTEL_LOGGER.serviceNameDerivedFromDeploymentUnit(serviceName);
            }
        }
        return serviceName;
    }

    private JBossWebMetaData getJBossWebMetaData(DeploymentUnit deploymentUnit) {
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (null == warMetaData) {
            return null;
        }
        return warMetaData.getMergedJBossWebMetaData();
    }
}

