/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.cache;

import java.io.Serializable;
import java.security.Principal;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;

public final class CachedIdentity
implements Serializable {
    private static final long serialVersionUID = -6408689383511392746L;
    private final String mechanismName;
    private final boolean programmatic;
    private final String name;
    private final transient SecurityIdentity securityIdentity;

    public CachedIdentity(String mechanismName, boolean programmatic, SecurityIdentity securityIdentity) {
        this(mechanismName, programmatic, Assert.checkNotNullParam("securityIdentity", securityIdentity), securityIdentity.getPrincipal());
    }

    public CachedIdentity(String mechanismName, boolean programmatic, Principal principal) {
        this(mechanismName, programmatic, null, principal);
    }

    private CachedIdentity(String mechanismName, boolean programmatic, SecurityIdentity securityIdentity, Principal principal) {
        this.mechanismName = Assert.checkNotNullParam("mechanismName", mechanismName);
        this.programmatic = programmatic;
        this.name = Assert.checkNotNullParam("name", Assert.checkNotNullParam("principal", principal).getName());
        this.securityIdentity = securityIdentity;
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    public String getName() {
        return this.name;
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public boolean isProgrammatic() {
        return this.programmatic;
    }

    public String toString() {
        return "CachedIdentity{" + this.mechanismName + ", '" + this.name + "', " + this.securityIdentity + ", " + this.programmatic + "}";
    }
}

