/*
 * Decompiled with CFR 0.152.
 */
package sun.corba;

import com.sun.corba.se.impl.encoding.CDROutputObject;
import com.sun.corba.se.impl.encoding.EncapsOutputStream;
import com.sun.corba.se.impl.encoding.TypeCodeOutputStream;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.transport.CorbaConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class OutputStreamFactory {
    private OutputStreamFactory() {
    }

    public static TypeCodeOutputStream newTypeCodeOutputStream(final ORB orb) {
        return AccessController.doPrivileged(new PrivilegedAction<TypeCodeOutputStream>(){

            @Override
            public TypeCodeOutputStream run() {
                return new TypeCodeOutputStream(orb);
            }
        });
    }

    public static TypeCodeOutputStream newTypeCodeOutputStream(final ORB orb, final boolean littleEndian) {
        return AccessController.doPrivileged(new PrivilegedAction<TypeCodeOutputStream>(){

            @Override
            public TypeCodeOutputStream run() {
                return new TypeCodeOutputStream(orb, littleEndian);
            }
        });
    }

    public static EncapsOutputStream newEncapsOutputStream(final ORB orb) {
        return AccessController.doPrivileged(new PrivilegedAction<EncapsOutputStream>(){

            @Override
            public EncapsOutputStream run() {
                return new EncapsOutputStream(orb);
            }
        });
    }

    public static EncapsOutputStream newEncapsOutputStream(final ORB orb, final GIOPVersion giopVersion) {
        return AccessController.doPrivileged(new PrivilegedAction<EncapsOutputStream>(){

            @Override
            public EncapsOutputStream run() {
                return new EncapsOutputStream(orb, giopVersion);
            }
        });
    }

    public static EncapsOutputStream newEncapsOutputStream(final ORB orb, final boolean isLittleEndian) {
        return AccessController.doPrivileged(new PrivilegedAction<EncapsOutputStream>(){

            @Override
            public EncapsOutputStream run() {
                return new EncapsOutputStream(orb, isLittleEndian);
            }
        });
    }

    public static CDROutputObject newCDROutputObject(final ORB orb, final MessageMediator messageMediator, final Message header, final byte streamFormatVersion) {
        return AccessController.doPrivileged(new PrivilegedAction<CDROutputObject>(){

            @Override
            public CDROutputObject run() {
                return new CDROutputObject(orb, messageMediator, header, streamFormatVersion);
            }
        });
    }

    public static CDROutputObject newCDROutputObject(final ORB orb, final MessageMediator messageMediator, final Message header, final byte streamFormatVersion, final int strategy) {
        return AccessController.doPrivileged(new PrivilegedAction<CDROutputObject>(){

            @Override
            public CDROutputObject run() {
                return new CDROutputObject(orb, messageMediator, header, streamFormatVersion, strategy);
            }
        });
    }

    public static CDROutputObject newCDROutputObject(final ORB orb, final CorbaMessageMediator mediator, final GIOPVersion giopVersion, final CorbaConnection connection, final Message header, final byte streamFormatVersion) {
        return AccessController.doPrivileged(new PrivilegedAction<CDROutputObject>(){

            @Override
            public CDROutputObject run() {
                return new CDROutputObject(orb, mediator, giopVersion, connection, header, streamFormatVersion);
            }
        });
    }
}

