/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.validator.ModelValidationStepHandler;
import org.wildfly.extension.picketlink.common.model.validator.UniqueTypeValidationStepHandler;
import org.wildfly.extension.picketlink.idm.model.AbstractIDMResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.CredentialTypeEnum;

public class CredentialHandlerResourceDefinition
extends AbstractIDMResourceDefinition {
    public static final SimpleAttributeDefinition CLASS_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_CLASS_NAME.getName(), ModelType.STRING, true).setAllowExpression(true)).setAlternatives(new String[]{ModelElement.COMMON_CODE.getName()})).build();
    public static final SimpleAttributeDefinition CODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_CODE.getName(), ModelType.STRING, true).setValidator((ParameterValidator)new EnumValidator(CredentialTypeEnum.class, true, true))).setAllowExpression(true)).setAlternatives(new String[]{ModelElement.COMMON_CLASS_NAME.getName()})).build();
    public static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_MODULE.getName(), ModelType.STRING, true).setAllowExpression(true)).setRequires(new String[]{ModelElement.COMMON_CLASS_NAME.getName()})).build();
    public static final CredentialHandlerResourceDefinition INSTANCE = new CredentialHandlerResourceDefinition(CLASS_NAME, CODE, MODULE);

    private CredentialHandlerResourceDefinition(SimpleAttributeDefinition ... attributes) {
        super(ModelElement.IDENTITY_STORE_CREDENTIAL_HANDLER, CredentialHandlerResourceDefinition.getModelValidators(), (PathAddress address) -> address.getParent().getParent().getParent(), attributes);
    }

    private static ModelValidationStepHandler[] getModelValidators() {
        return new ModelValidationStepHandler[]{new UniqueTypeValidationStepHandler(ModelElement.IDENTITY_STORE_CREDENTIAL_HANDLER){

            @Override
            protected String getType(OperationContext context, ModelNode model) throws OperationFailedException {
                return CredentialHandlerResourceDefinition.getCredentialType(context, model);
            }
        }};
    }

    private static String getCredentialType(OperationContext context, ModelNode elementNode) throws OperationFailedException {
        ModelNode classNameNode = CLASS_NAME.resolveModelAttribute(context, elementNode);
        ModelNode codeNode = CODE.resolveModelAttribute(context, elementNode);
        if (classNameNode.isDefined()) {
            return classNameNode.asString();
        }
        return CredentialTypeEnum.forType(codeNode.asString());
    }
}

