/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.jdbc.spi.ConnectionObserver;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.ConnectionObserverStatsBridge;
import org.hibernate.resource.jdbc.spi.JdbcObserver;

public class JdbcObserverImpl
implements JdbcObserver {
    private final SharedSessionContractImplementor session;
    private final transient List<ConnectionObserver> observers;

    public JdbcObserverImpl(SharedSessionContractImplementor session) {
        this.session = session;
        this.observers = new ArrayList<ConnectionObserver>();
        this.observers.add(new ConnectionObserverStatsBridge(session.getFactory()));
    }

    @Override
    public void jdbcConnectionAcquisitionStart() {
    }

    @Override
    public void jdbcConnectionAcquisitionEnd(Connection connection) {
        for (ConnectionObserver observer : this.observers) {
            observer.physicalConnectionObtained(connection);
        }
    }

    @Override
    public void jdbcConnectionReleaseStart() {
    }

    @Override
    public void jdbcConnectionReleaseEnd() {
        for (ConnectionObserver observer : this.observers) {
            observer.physicalConnectionReleased();
        }
    }

    @Override
    public void jdbcPrepareStatementStart() {
        this.session.getEventListenerManager().jdbcPrepareStatementStart();
    }

    @Override
    public void jdbcPrepareStatementEnd() {
        for (ConnectionObserver observer : this.observers) {
            observer.statementPrepared();
        }
        this.session.getEventListenerManager().jdbcPrepareStatementEnd();
    }

    @Override
    public void jdbcExecuteStatementStart() {
        this.session.getEventListenerManager().jdbcExecuteStatementStart();
    }

    @Override
    public void jdbcExecuteStatementEnd() {
        this.session.getEventListenerManager().jdbcExecuteStatementEnd();
    }

    @Override
    public void jdbcExecuteBatchStart() {
        this.session.getEventListenerManager().jdbcExecuteBatchStart();
    }

    @Override
    public void jdbcExecuteBatchEnd() {
        this.session.getEventListenerManager().jdbcExecuteBatchEnd();
    }

    @Override
    public void jdbcReleaseRegistryResourcesStart() {
        this.session.getJdbcCoordinator().abortBatch();
    }

    @Override
    public void jdbcReleaseRegistryResourcesEnd() {
    }
}

