/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedType;
import org.jboss.weld.bean.proxy.InterceptedProxyFactory;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.injection.producer.InterceptionModelInitializer;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;

public class InterceptionFactoryDataCache
implements Service {
    private static final AtomicLong INDEX = new AtomicLong();
    private final ComputingCache<Key, Optional<InterceptionFactoryData<?>>> cache = ComputingCacheBuilder.newBuilder().build(key -> {
        boolean hasNonConstructorInterceptors;
        ClassTransformer classTransformer = (ClassTransformer)beanManager.getServices().get(ClassTransformer.class);
        long idx = INDEX.incrementAndGet();
        String id = ((Key)key).annotatedType.getJavaClass().getName() + "$$" + idx;
        UnbackedAnnotatedType slimAnnotatedType = classTransformer.getUnbackedAnnotatedType(((Key)key).annotatedType, beanManager.getId(), id);
        EnhancedAnnotatedType enhancedAnnotatedType = classTransformer.getEnhancedAnnotatedType(slimAnnotatedType);
        new InterceptionModelInitializer(beanManager, enhancedAnnotatedType, Beans.getBeanConstructor(enhancedAnnotatedType), null).init();
        InterceptionModel interceptionModel = (InterceptionModel)beanManager.getInterceptorModelRegistry().get(slimAnnotatedType);
        boolean bl = hasNonConstructorInterceptors = interceptionModel != null && (interceptionModel.hasExternalNonConstructorInterceptors() || interceptionModel.hasTargetClassInterceptors());
        if (!hasNonConstructorInterceptors) {
            return Optional.empty();
        }
        HashSet<MethodSignature> enhancedMethodSignatures = new HashSet<MethodSignature>();
        HashSet<MethodSignature> interceptedMethodSignatures = new HashSet<MethodSignature>();
        for (AnnotatedMethod annotatedMethod : Beans.getInterceptableMethods(enhancedAnnotatedType)) {
            enhancedMethodSignatures.add(MethodSignatureImpl.of(annotatedMethod));
            if (interceptionModel.getInterceptors(InterceptionType.AROUND_INVOKE, annotatedMethod.getJavaMember()).isEmpty()) continue;
            interceptedMethodSignatures.add(MethodSignatureImpl.of(annotatedMethod));
        }
        InterceptedProxyFactory proxyFactory = new InterceptedProxyFactory(beanManager.getContextId(), enhancedAnnotatedType.getJavaClass(), Collections.singleton(enhancedAnnotatedType.getJavaClass()), enhancedMethodSignatures, interceptedMethodSignatures, "" + idx);
        InterceptionFactoryData interceptionFactoryData = new InterceptionFactoryData(proxyFactory, slimAnnotatedType, interceptionModel);
        return Optional.of(interceptionFactoryData);
    });

    public InterceptionFactoryDataCache(BeanManagerImpl beanManager) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Optional<InterceptionFactoryData<T>> getInterceptionFactoryData(AnnotatedType<T> annotatedType) {
        Key key = new Key(AnnotatedTypes.createTypeId(annotatedType), annotatedType);
        try {
            Optional optional = (Optional)this.cache.getCastValue(key);
            return optional;
        }
        finally {
            key.cleanupAfterUse();
        }
    }

    public void cleanup() {
        this.cache.clear();
    }

    private static class Key {
        private final String typeId;
        private AnnotatedType<?> annotatedType;

        Key(String typeId, AnnotatedType<?> annotatedType) {
            this.typeId = typeId;
            this.annotatedType = annotatedType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.typeId == null ? 0 : this.typeId.hashCode());
            return result;
        }

        void cleanupAfterUse() {
            this.annotatedType = null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return !(this.typeId == null ? other.typeId != null : !this.typeId.equals(other.typeId));
        }
    }

    public static class InterceptionFactoryData<T> {
        private final InterceptedProxyFactory<T> interceptedProxyFactory;
        private final SlimAnnotatedType<T> slimAnnotatedType;
        private final InterceptionModel interceptionModel;

        InterceptionFactoryData(InterceptedProxyFactory<T> interceptedProxyFactory, SlimAnnotatedType<T> slimAnnotatedType, InterceptionModel interceptionModel) {
            this.interceptedProxyFactory = interceptedProxyFactory;
            this.slimAnnotatedType = slimAnnotatedType;
            this.interceptionModel = interceptionModel;
        }

        public InterceptedProxyFactory<T> getInterceptedProxyFactory() {
            return this.interceptedProxyFactory;
        }

        public SlimAnnotatedType<T> getSlimAnnotatedType() {
            return this.slimAnnotatedType;
        }

        public InterceptionModel getInterceptionModel() {
            return this.interceptionModel;
        }
    }
}

