/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.parsing.ExpressionBaseState;
import org.jboss.as.cli.parsing.WordCharacterHandler;
import org.wildfly.common.Assert;

public abstract class FilenameTabCompleter
implements CommandLineCompleter {
    private final CommandContext ctx;

    public FilenameTabCompleter(CommandContext ctx) {
        this.ctx = Assert.checkNotNullParam("ctx", ctx);
    }

    protected int getCandidates(String buffer, List<String> candidates) {
        String clearedPath = FilenameTabCompleter.clearPath(buffer);
        String translated = this.translatePath(clearedPath);
        File f = new File(translated);
        File dir = translated.endsWith(File.separator) ? f : f.getParentFile();
        File[] entries = dir == null ? new File[]{} : dir.listFiles();
        return this.matchFiles(buffer, translated, entries, candidates);
    }

    public static FilenameTabCompleter newCompleter(CommandContext ctx) {
        return Util.isWindows() ? new WindowsFilenameTabCompleter(ctx) : new DefaultFilenameTabCompleter(ctx);
    }

    public String translatePath(String path) {
        String translated;
        if (path.startsWith("~" + File.separator)) {
            translated = System.getProperty("user.home") + path.substring(1);
        } else if (path.startsWith("~")) {
            String userName = path.substring(1);
            translated = new File(new File(System.getProperty("user.home")).getParent(), userName).getAbsolutePath();
            translated = userName.isEmpty() || path.endsWith(File.separator) ? translated + File.separator : translated;
        } else {
            translated = !new File(path).isAbsolute() ? this.ctx.getCurrentDir().getAbsolutePath() + File.separator + path : path;
        }
        return translated;
    }

    private static String clearPath(String path) {
        try {
            ExpressionBaseState state = new ExpressionBaseState("EXPR", true, false);
            if (Util.isWindows()) {
                state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_OFF);
            } else {
                state.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
            }
            path = ArgumentWithValue.resolveValue(path, state);
        }
        catch (CommandFormatException commandFormatException) {
            // empty catch block
        }
        if (path.startsWith("\"")) {
            path = path.substring(1);
        }
        if (path.endsWith("\"")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected int matchFiles(String buffer, String translated, File[] entries, List<String> candidates) {
        if (entries == null) {
            return -1;
        }
        boolean isDirectory = false;
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getAbsolutePath().startsWith(translated)) continue;
            isDirectory = entries[i].isDirectory();
            candidates.add(entries[i].getName());
        }
        if (candidates.size() == 1) {
            String candidate = candidates.get(0);
            if (isDirectory) {
                candidate = candidate + File.separator;
            }
            candidates.set(0, candidate);
        }
        int index = buffer.lastIndexOf(File.separatorChar) + 1;
        return index;
    }

    public static String expand(String path) throws IOException {
        Assert.checkNotNullParamWithNullPointerException("path", path);
        if (path.startsWith("~")) {
            String home = System.getProperty("user.home");
            if (home == null) {
                throw new IOException("Path " + path + " can't be expanded. No user.home property");
            }
            if (path.startsWith("~" + File.separator)) {
                path = new File(home, path.substring(2)).getAbsolutePath();
            } else {
                int i = path.indexOf(File.separator);
                if (i < 0 || i >= path.length() - 1) {
                    throw new IOException("Invalid file " + path);
                }
                String user = path.substring(1, i);
                File homeDir = new File(new File(home).getParent(), user);
                path = new File(homeDir, path.substring(i + 1)).getAbsolutePath();
            }
        }
        return path;
    }

    void postProcess(String buffer, List<String> candidates) {
        if (candidates.size() == 1) {
            String candidate = candidates.get(0);
            if (!buffer.contains(File.separator)) {
                if (buffer.startsWith("\"~")) {
                    candidate = "\"~" + candidate;
                } else if (buffer.startsWith("\"")) {
                    candidate = "\"" + candidate;
                } else if (buffer.startsWith("~")) {
                    candidate = "~" + candidate;
                }
            }
            candidates.set(0, candidate);
        }
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        int result = this.getCandidates(buffer, candidates);
        Collections.sort(candidates);
        this.completeCandidates(ctx, buffer, cursor, candidates);
        this.postProcess(buffer, candidates);
        return result;
    }

    abstract void completeCandidates(CommandContext var1, String var2, int var3, List<String> var4);
}

