/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.util.HashSet;
import java.util.Set;
import javax.jws.WebService;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.metadata.model.AbstractEndpoint;
import org.jboss.as.webservices.metadata.model.JAXWSDeployment;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.webservices.verification.JwsWebServiceEndpointVerifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class WSClassVerificationProcessor
implements DeploymentUnitProcessor {
    private static final Set<String> cxfExportingModules = new HashSet<String>();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        JAXWSDeployment wsDeployment = (JAXWSDeployment)unit.getAttachment(WSAttachmentKeys.JAXWS_ENDPOINTS_KEY);
        if (wsDeployment != null) {
            Module module = (Module)unit.getAttachment(Attachments.MODULE);
            DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)unit.getAttachment(Attachments.REFLECTION_INDEX);
            ModuleClassLoader moduleClassLoader = module.getClassLoader();
            for (AbstractEndpoint pojoEndpoint : wsDeployment.getPojoEndpoints()) {
                this.verifyEndpoint(pojoEndpoint, (ClassLoader)moduleClassLoader, deploymentReflectionIndex);
            }
            for (AbstractEndpoint ejbEndpoint : wsDeployment.getEjbEndpoints()) {
                this.verifyEndpoint(ejbEndpoint, (ClassLoader)moduleClassLoader, deploymentReflectionIndex);
            }
            this.verifyApacheCXFModuleDependencyRequirement(unit);
        }
    }

    private void verifyEndpoint(AbstractEndpoint pojoEndpoint, ClassLoader moduleClassLoader, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        if (WSLogger.ROOT_LOGGER.isTraceEnabled()) {
            WSLogger.ROOT_LOGGER.tracef("Verifying web service endpoint class %s", pojoEndpoint.getClassName());
        }
        try {
            Class<?> endpointClass = moduleClassLoader.loadClass(pojoEndpoint.getClassName());
            WebService webServiceAnnotation = endpointClass.getAnnotation(WebService.class);
            if (webServiceAnnotation != null) {
                this.verifyJwsEndpoint(endpointClass, webServiceAnnotation, moduleClassLoader, deploymentReflectionIndex);
            }
        }
        catch (ClassNotFoundException e) {
            throw WSLogger.ROOT_LOGGER.endpointClassNotFound(pojoEndpoint.getClassName());
        }
    }

    void verifyJwsEndpoint(Class<?> endpointClass, WebService webServiceAnnotation, ClassLoader moduleClassLoader, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        String endpointInterfaceClassName = webServiceAnnotation.endpointInterface();
        try {
            Class<?> endpointInterfaceClass = endpointInterfaceClassName.length() > 0 ? moduleClassLoader.loadClass(endpointInterfaceClassName) : null;
            JwsWebServiceEndpointVerifier wsEndpointVerifier = new JwsWebServiceEndpointVerifier(endpointClass, endpointInterfaceClass, deploymentReflectionIndex);
            wsEndpointVerifier.verify();
            if (wsEndpointVerifier.failed()) {
                wsEndpointVerifier.logFailures();
                throw WSLogger.ROOT_LOGGER.jwsWebServiceClassVerificationFailed(endpointClass);
            }
        }
        catch (ClassNotFoundException e) {
            throw WSLogger.ROOT_LOGGER.declaredEndpointInterfaceClassNotFound(endpointInterfaceClassName, endpointClass);
        }
    }

    private void verifyApacheCXFModuleDependencyRequirement(DeploymentUnit unit) {
        if (!WSClassVerificationProcessor.hasCxfModuleDependency(unit)) {
            DotName[] dotNames;
            CompositeIndex index = (CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
            for (DotName dotName : dotNames = new DotName[]{DotNames.WEB_SERVICE_ANNOTATION, DotNames.WEB_SERVICE_PROVIDER_ANNOTATION}) {
                for (AnnotationInstance ai : index.getAnnotations(dotName)) {
                    AnnotationTarget at = ai.target();
                    if (!(at instanceof ClassInfo)) continue;
                    ClassInfo clazz = (ClassInfo)ai.target();
                    for (DotName dn : clazz.annotations().keySet()) {
                        if (!dn.toString().startsWith("org.apache.cxf")) continue;
                        WSLogger.ROOT_LOGGER.missingModuleDependency(dn.toString(), clazz.name().toString(), "org.apache.cxf");
                    }
                }
            }
        }
    }

    static boolean hasCxfModuleDependency(DeploymentUnit unit) {
        ModuleSpecification moduleSpec = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
        for (ModuleDependency dep : moduleSpec.getUserDependencies()) {
            String id = dep.getIdentifier().getName();
            if (!cxfExportingModules.contains(id)) continue;
            return true;
        }
        return WSClassVerificationProcessor.hasExportedCxfModuleDependency(unit.getParent()) || WSClassVerificationProcessor.hasSiblingCxfModuleDependency(unit);
    }

    private static boolean hasExportedCxfModuleDependency(DeploymentUnit unit) {
        if (unit != null) {
            ModuleSpecification moduleSpec = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
            for (ModuleDependency dep : moduleSpec.getUserDependencies()) {
                String id = dep.getIdentifier().getName();
                if (!cxfExportingModules.contains(id) || !dep.isExport()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasSiblingCxfModuleDependency(DeploymentUnit unit) {
        if (unit.getParent() == null) {
            return false;
        }
        ModuleSpecification rootModuleSpec = (ModuleSpecification)unit.getParent().getAttachment(Attachments.MODULE_SPECIFICATION);
        if (!rootModuleSpec.isSubDeploymentModulesIsolated()) {
            for (DeploymentUnit siblingUnit : (AttachmentList)unit.getParent().getAttachment(Attachments.SUB_DEPLOYMENTS)) {
                if (!siblingUnit.getName().endsWith(".jar") || siblingUnit.equals(unit) || !WSClassVerificationProcessor.hasExportedCxfModuleDependency(siblingUnit)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        cxfExportingModules.add("org.apache.cxf");
        cxfExportingModules.add("org.apache.cxf.impl");
        cxfExportingModules.add("org.jboss.ws.cxf.jbossws-cxf-client");
    }
}

