/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import java.util.List;
import java.util.function.Function;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.idm.IDMExtension;
import org.wildfly.extension.picketlink.idm.model.AbstractIDMResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.IdentityConfigurationResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.SupportedTypeResourceDefinition;
import org.wildfly.extension.picketlink.idm.model.SupportedTypesResourceDefinition;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class PartitionManagerResourceDefinition
extends AbstractIDMResourceDefinition {
    private static final List<AccessConstraintDefinition> CONSTRAINTS = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("picketlink-identity-management", "partition-manager", false, true, true)).wrapAsList();
    public static final SimpleAttributeDefinition IDENTITY_MANAGEMENT_JNDI_URL = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.IDENTITY_MANAGEMENT_JNDI_NAME.getName(), ModelType.STRING, false).setAllowExpression(true)).build();
    public static final PartitionManagerResourceDefinition INSTANCE = new PartitionManagerResourceDefinition();

    private PartitionManagerResourceDefinition() {
        super(ModelElement.PARTITION_MANAGER, Function.identity(), IDENTITY_MANAGEMENT_JNDI_URL);
        this.setDeprecated(IDMExtension.DEPRECATED_SINCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        this.addChildResourceDefinition(IdentityConfigurationResourceDefinition.INSTANCE, resourceRegistration);
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return CONSTRAINTS;
    }

    public static void validateModel(OperationContext context, PathAddress partitionAddress) throws OperationFailedException {
        ModelNode partitionManager = PartitionManagerResourceDefinition.getPartitionManagerModel(context, partitionAddress);
        if (partitionManager == null) {
            return;
        }
        ModelNode identityConfigurationNode = partitionManager.get(ModelElement.IDENTITY_CONFIGURATION.getName());
        if (!identityConfigurationNode.isDefined()) {
            throw PicketLinkLogger.ROOT_LOGGER.idmNoIdentityConfigurationProvided();
        }
        for (Property identityConfiguration : identityConfigurationNode.asPropertyList()) {
            String configurationName = identityConfiguration.getName();
            if (!identityConfiguration.getValue().isDefined()) {
                throw PicketLinkLogger.ROOT_LOGGER.idmNoIdentityStoreProvided(configurationName);
            }
            List identityStores = identityConfiguration.getValue().asList();
            for (ModelNode store : identityStores) {
                PartitionManagerResourceDefinition.configureIdentityStore(context, store);
            }
        }
    }

    private static ModelNode getPartitionManagerModel(OperationContext context, PathAddress partitionAddress) {
        try {
            Resource resource = context.readResourceFromRoot(partitionAddress);
            return Resource.Tools.readModel((Resource)resource);
        }
        catch (Resource.NoSuchResourceException e) {
            return null;
        }
    }

    private static void configureIdentityStore(OperationContext context, ModelNode modelNode) throws OperationFailedException {
        Property prop = modelNode.asProperty();
        String storeType = prop.getName();
        ModelNode identityStore = prop.getValue().asProperty().getValue();
        if (storeType.equals(ModelElement.LDAP_STORE.getName()) && !identityStore.hasDefined(ModelElement.LDAP_STORE_MAPPING.getName())) {
            throw PicketLinkLogger.ROOT_LOGGER.idmLdapNoMappingDefined();
        }
        PartitionManagerResourceDefinition.validateSupportedTypes(context, identityStore);
    }

    private static void validateSupportedTypes(OperationContext context, ModelNode identityStore) throws OperationFailedException {
        boolean hasSupportedType = identityStore.hasDefined(ModelElement.SUPPORTED_TYPES.getName());
        if (hasSupportedType) {
            ModelNode featuresSetNode = identityStore.get(ModelElement.SUPPORTED_TYPES.getName()).asProperty().getValue();
            try {
                ModelNode supportsAllNode = SupportedTypesResourceDefinition.SUPPORTS_ALL.resolveModelAttribute(context, featuresSetNode);
                hasSupportedType = supportsAllNode.asBoolean();
            }
            catch (OperationFailedException ofe) {
                if (featuresSetNode.get(SupportedTypesResourceDefinition.SUPPORTS_ALL.getName()).getType() == ModelType.EXPRESSION) {
                    hasSupportedType = true;
                }
                throw ofe;
            }
            if (featuresSetNode.hasDefined(ModelElement.SUPPORTED_TYPE.getName())) {
                for (Property supportedTypeNode : featuresSetNode.get(ModelElement.SUPPORTED_TYPE.getName()).asPropertyList()) {
                    ModelNode supportedType = supportedTypeNode.getValue();
                    if (!supportedType.hasDefined(SupportedTypeResourceDefinition.CLASS_NAME.getName()) && !supportedType.hasDefined(SupportedTypeResourceDefinition.CODE.getName())) {
                        throw PicketLinkLogger.ROOT_LOGGER.typeNotProvided(ModelElement.SUPPORTED_TYPE.getName());
                    }
                    hasSupportedType = true;
                }
            }
        }
        if (!hasSupportedType) {
            throw PicketLinkLogger.ROOT_LOGGER.idmNoSupportedTypesDefined();
        }
    }
}

