/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.wildfly.transaction.client._private.Log;

public final class SimpleXid
implements Xid,
Comparable<SimpleXid> {
    public static final byte[] NO_BYTES = new byte[0];
    public static final Xid[] NO_XIDS = new Xid[0];
    public static final SimpleXid[] NO_SIMPLE_XIDS = new SimpleXid[0];
    public static final SimpleXid EMPTY = new SimpleXid(0, NO_BYTES, NO_BYTES, false);
    private static final char DEFAULT_SEPARATOR = ':';
    private final int formatId;
    private final byte[] globalId;
    private final byte[] branchId;
    private final int hashCode;

    public SimpleXid(int formatId, byte[] gtId, byte[] bq) {
        this(formatId, gtId, bq, true);
    }

    private SimpleXid(int formatId, byte[] gtId, byte[] bq, boolean clone) {
        this.formatId = formatId;
        int globalIdLength = gtId.length;
        int branchIdLength = bq.length;
        byte[] byArray = globalIdLength > 0 ? (clone ? (byte[])gtId.clone() : gtId) : (this.globalId = NO_BYTES);
        this.branchId = branchIdLength > 0 ? (clone ? (byte[])bq.clone() : bq) : NO_BYTES;
        this.hashCode = (formatId * 31 + Arrays.hashCode(this.globalId)) * 31 + Arrays.hashCode(this.branchId);
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        byte[] globalId = this.globalId;
        return globalId.length == 0 ? globalId : (byte[])globalId.clone();
    }

    @Override
    public byte[] getBranchQualifier() {
        byte[] branchId = this.branchId;
        return branchId.length == 0 ? branchId : (byte[])branchId.clone();
    }

    public boolean equals(Object obj) {
        return obj instanceof SimpleXid && this.equals((SimpleXid)obj);
    }

    public boolean equals(SimpleXid obj) {
        return obj != null && this.hashCode == obj.hashCode && this.formatId == obj.formatId && Arrays.equals(this.globalId, obj.globalId) && Arrays.equals(this.branchId, obj.branchId);
    }

    public SimpleXid withoutBranch() {
        if (this.branchId.length == 0) {
            return this;
        }
        return new SimpleXid(this.formatId, this.globalId, NO_BYTES, false);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static SimpleXid of(Xid xid) {
        return xid instanceof SimpleXid ? (SimpleXid)xid : new SimpleXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    public static SimpleXid of(String xidHexString, char separator) {
        String[] xidParts = xidHexString.split(String.valueOf(separator));
        if (xidParts.length != 3) {
            throw Log.log.failToConvertHexadecimalFormatToSimpleXid(xidHexString, String.valueOf(separator));
        }
        return new SimpleXid(Integer.parseUnsignedInt(xidParts[0], 16), SimpleXid.hexStringToByteArray(xidParts[1]), SimpleXid.hexStringToByteArray(xidParts[2]));
    }

    public static SimpleXid of(String xidHexString) {
        return SimpleXid.of(xidHexString, ':');
    }

    @Override
    public int compareTo(SimpleXid o) {
        int res = Integer.signum(this.formatId - o.formatId);
        if (res == 0) {
            res = SimpleXid.compareByteArrays(this.globalId, o.globalId);
        }
        if (res == 0) {
            res = SimpleXid.compareByteArrays(this.branchId, o.branchId);
        }
        assert (res == 0 == this.equals(o));
        return res;
    }

    public String toHexString() {
        return this.toHexString(':');
    }

    public String toHexString(char separator) {
        StringBuilder b = new StringBuilder();
        this.toHexString(b, separator);
        return b.toString();
    }

    private void toHexString(StringBuilder builder, char separator) {
        int v;
        builder.append(Integer.toHexString(this.formatId)).append(separator);
        for (byte x : this.globalId) {
            v = x & 0xFF;
            if (v < 16) {
                builder.append('0');
            }
            builder.append(Integer.toHexString(v));
        }
        builder.append(separator);
        for (byte x : this.branchId) {
            v = x & 0xFF;
            if (v < 16) {
                builder.append('0');
            }
            builder.append(Integer.toHexString(v));
        }
    }

    private static int compareByteArrays(byte[] a1, byte[] a2) {
        int l1 = a1.length;
        int l2 = a2.length;
        int minLen = Math.min(l1, l2);
        for (int i = 0; i < minLen; ++i) {
            int res = Integer.signum((a1[i] & 0xFF) - (a2[i] & 0xFF));
            if (res == 0) continue;
            return res;
        }
        return Integer.signum(l1 - l2);
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("XID [");
        this.toHexString(b, ':');
        b.append(']');
        return b.toString();
    }
}

