/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.Query;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.query.dsl.SpatialTermination;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.SpatialQueryContext;
import org.hibernate.search.spatial.SpatialFieldBridgeByHash;
import org.hibernate.search.spatial.SpatialFieldBridgeByRange;
import org.hibernate.search.spatial.impl.SpatialQueryBuilderFromCoordinates;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ConnectedSpatialQueryBuilder
implements SpatialTermination {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final SpatialQueryContext spatialContext;
    private final QueryCustomizer queryCustomizer;
    private final QueryBuildingContext queryContext;

    public ConnectedSpatialQueryBuilder(SpatialQueryContext spatialContext, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.spatialContext = spatialContext;
        this.queryCustomizer = queryCustomizer;
        this.queryContext = queryContext;
    }

    @Override
    public Query createQuery() {
        return this.queryCustomizer.setWrappedQuery(this.createSpatialQuery()).createQuery();
    }

    private Query createSpatialQuery() {
        String coordinatesField;
        DocumentBuilderIndexedEntity documentBuilder = this.queryContext.getDocumentBuilder();
        FieldBridge fieldBridge = documentBuilder.getBridge(coordinatesField = this.spatialContext.getCoordinatesField());
        if (fieldBridge instanceof SpatialFieldBridgeByHash) {
            return SpatialQueryBuilderFromCoordinates.buildSpatialQueryByHash(this.spatialContext.getCoordinates(), this.spatialContext.getRadiusDistance(), coordinatesField);
        }
        if (fieldBridge instanceof SpatialFieldBridgeByRange) {
            return SpatialQueryBuilderFromCoordinates.buildSpatialQueryByRange(this.spatialContext.getCoordinates(), this.spatialContext.getRadiusDistance(), coordinatesField);
        }
        throw LOG.targetedFieldNotSpatial(this.queryContext.getEntityType().getName(), coordinatesField);
    }
}

