/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.Principal;
import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableRealmIdentityIterator;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.credential.Credential;

public class FileSystemRealmUtil {
    public static void createEncryptedRealmFromUnencrypted(FileSystemSecurityRealm unencryptedRealm, FileSystemSecurityRealm encryptedRealm) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"unencryptedRealm", (Object)unencryptedRealm);
        Assert.checkNotNullParam((String)"encryptedRealm", (Object)encryptedRealm);
        ModifiableRealmIdentityIterator realmIterator = unencryptedRealm.getRealmIdentityIterator();
        while (realmIterator.hasNext()) {
            ModifiableRealmIdentity identity = (ModifiableRealmIdentity)realmIterator.next();
            List<Credential> credentials = ((FileSystemSecurityRealm.Identity)identity).loadCredentials();
            Attributes attributes = identity.getAttributes();
            ModifiableRealmIdentity newIdentity = encryptedRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal(identity.getRealmIdentityPrincipal().getName()));
            newIdentity.create();
            newIdentity.setCredentials(credentials);
            newIdentity.setAttributes(attributes);
            newIdentity.dispose();
        }
        realmIterator.close();
    }
}

