/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.integration;

import javax.resource.spi.XATerminator;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.tm.JBossXATerminator;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;

public class JBossContextXATerminator
implements JBossXATerminator {
    private final LocalTransactionContext localTransactionContext;
    private final XATerminator contextXATerminator;
    private final JBossXATerminator jbossXATerminator;

    public JBossContextXATerminator(LocalTransactionContext transactionContext, JBossXATerminator jbossXATerminator) {
        this.localTransactionContext = transactionContext;
        this.contextXATerminator = transactionContext.getXATerminator();
        this.jbossXATerminator = jbossXATerminator;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.contextXATerminator.commit(xid, onePhase);
    }

    public void forget(Xid xid) throws XAException {
        this.contextXATerminator.forget(xid);
    }

    public int prepare(Xid xid) throws XAException {
        return this.contextXATerminator.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.contextXATerminator.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this.contextXATerminator.rollback(xid);
    }

    public void registerWork(Work work, Xid xid, long timeout) throws WorkCompletedException {
        try {
            int timeout_seconds = (int)timeout / 1000;
            if (timeout_seconds <= 0) {
                timeout_seconds = ContextTransactionManager.getGlobalDefaultTransactionTimeout();
            }
            this.localTransactionContext.findOrImportTransaction(xid, timeout_seconds);
        }
        catch (XAException xae) {
            throw TransactionLogger.ROOT_LOGGER.cannotFindOrImportInflowTransaction(xid, work, xae);
        }
        this.jbossXATerminator.registerWork(work, xid, timeout);
    }

    public void startWork(Work work, Xid xid) throws WorkCompletedException {
        LocalTransaction transaction = null;
        try {
            ImportResult transactionImportResult = this.localTransactionContext.findOrImportTransaction(xid, 0);
            transaction = (LocalTransaction)transactionImportResult.getTransaction();
            ContextTransactionManager.getInstance().resume((Transaction)transaction);
        }
        catch (XAException xae) {
            throw TransactionLogger.ROOT_LOGGER.cannotFindOrImportInflowTransaction(xid, work, xae);
        }
        catch (InvalidTransactionException ite) {
            throw TransactionLogger.ROOT_LOGGER.importedInflowTransactionIsInactive(xid, work, (Exception)((Object)ite));
        }
        catch (SystemException se) {
            throw TransactionLogger.ROOT_LOGGER.cannotResumeInflowTransactionUnexpectedError((Transaction)transaction, work, (Exception)((Object)se));
        }
    }

    public void endWork(Work work, Xid xid) {
        this.jbossXATerminator.cancelWork(work, xid);
        try {
            ContextTransactionManager.getInstance().suspend();
        }
        catch (SystemException se) {
            throw TransactionLogger.ROOT_LOGGER.cannotSuspendInflowTransactionUnexpectedError(work, (Exception)((Object)se));
        }
    }

    public void cancelWork(Work work, Xid xid) {
        this.jbossXATerminator.cancelWork(work, xid);
    }
}

