/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;

public class ActiveMQRAConnectionManager
implements ConnectionManager {
    static final long serialVersionUID = 4409118162975011014L;
    ConcurrentHashSet<ManagedConnection> connections = new ConcurrentHashSet();

    public ActiveMQRAConnectionManager() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("constructor()");
        }
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("allocateConnection(" + mcf + ", " + cxRequestInfo + ")");
        }
        ManagedConnection mc = mcf.createManagedConnection(null, cxRequestInfo);
        Object c = mc.getConnection(null, cxRequestInfo);
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("Allocated connection: " + c + ", with managed connection: " + mc);
        }
        this.connections.add((Object)mc);
        return c;
    }

    public void stop() {
        for (ManagedConnection conn : this.connections) {
            try {
                conn.destroy();
            }
            catch (Throwable throwable) {}
        }
    }
}

