/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanRemover;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;

public class InfinispanBean<I, T>
implements Bean<I, T> {
    private final I id;
    private final BeanEntry<I> entry;
    private final BeanGroup<I, T> group;
    private final Mutator mutator;
    private final BeanRemover<I, T> remover;
    private final Duration timeout;
    private final PassivationListener<T> listener;
    private final AtomicBoolean valid = new AtomicBoolean(true);

    public InfinispanBean(I id, BeanEntry<I> entry, BeanGroup<I, T> group, Mutator mutator, BeanRemover<I, T> remover, Duration timeout, PassivationListener<T> listener) {
        this.id = id;
        this.entry = entry;
        this.group = group;
        this.mutator = mutator;
        this.remover = remover;
        this.timeout = timeout;
        this.listener = listener;
    }

    public I getId() {
        return this.id;
    }

    public I getGroupId() {
        return (I)this.entry.getGroupId();
    }

    public boolean isExpired() {
        return this.entry.isExpired(this.timeout) && this.group.isCloseable();
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public void remove(RemoveListener<T> listener) {
        if (this.valid.compareAndSet(true, false)) {
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Removing bean %s", this.id);
            this.remover.remove(this.id, listener);
        }
    }

    public T acquire() {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Acquiring reference to bean %s", this.id);
        return this.group.getBean(this.id, this.listener);
    }

    public boolean release() {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Releasing reference to bean %s", this.id);
        return this.group.releaseBean(this.id, this.listener);
    }

    public void close() {
        if (this.valid.get()) {
            Instant lastAccessedTime = this.entry.getLastAccessedTime();
            Instant now = Instant.now();
            this.entry.setLastAccessedTime(now.getNano() % 1000000 > 0 ? now.with(ChronoField.MILLI_OF_SECOND, now.get(ChronoField.MILLI_OF_SECOND)) : now);
            if (lastAccessedTime != null) {
                this.mutator.mutate();
            }
        }
        if (this.group.isCloseable()) {
            this.group.close();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Bean)) {
            return false;
        }
        Bean bean = (Bean)object;
        return this.id.equals(bean.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id.toString();
    }
}

