/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.protocol;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.jboss.logging.Logger;

public class EmbedMessageUtil {
    private static final String AMQP_ENCODE_PROPERTY = "_AMQP_EMBED_LARGE";
    private static final byte[] signature = new byte[]{69, 77, 66};
    private static final Logger logger = Logger.getLogger(EmbedMessageUtil.class);

    public static ICoreMessage embedAsCoreMessage(Message source) {
        if (source instanceof ICoreMessage) {
            return (ICoreMessage)source;
        }
        if (source.isLargeMessage()) {
            LargeServerMessage largeSource = (LargeServerMessage)source;
            LargeServerMessageImpl largeServerMessage = new LargeServerMessageImpl(8, source.getMessageID(), largeSource.getStorageManager(), largeSource.getLargeBody().createFile());
            largeServerMessage.setDurable(source.isDurable());
            int size = source.getPersister().getEncodeSize((Object)source);
            byte[] arrayByte = new byte[size];
            ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])arrayByte);
            buffer.resetWriterIndex();
            source.getPersister().encode(buffer, (Object)source);
            largeServerMessage.toMessage().putBytesProperty(AMQP_ENCODE_PROPERTY, arrayByte);
            largeServerMessage.setParentRef((RefCountMessage)source);
            return (ICoreMessage)largeServerMessage.toMessage();
        }
        Persister persister = source.getPersister();
        CoreMessage message = new CoreMessage(source.getMessageID(), persister.getEncodeSize((Object)source) + signature.length + 4).setType((byte)7);
        message.setDurable(source.isDurable());
        ActiveMQBuffer buffer = message.getBodyBuffer();
        buffer.writeBytes(signature);
        persister.encode(buffer, (Object)source);
        return message;
    }

    public static Message extractEmbedded(ICoreMessage message, StorageManager storageManager) {
        switch (message.getType()) {
            case 7: {
                return EmbedMessageUtil.extractRegularMessage(message, storageManager);
            }
            case 8: {
                return EmbedMessageUtil.extractLargeMessage(message, storageManager);
            }
        }
        return message;
    }

    private static Message extractRegularMessage(ICoreMessage message, StorageManager storageManager) {
        ActiveMQBuffer buffer = message.getReadOnlyBodyBuffer();
        if (buffer.readableBytes() < signature.length || !EmbedMessageUtil.checkSignature(buffer)) {
            logger.tracef("Message type %d was used for something other than embed messages, ignoring content and treating as a regular message", 7);
            return message;
        }
        return EmbedMessageUtil.readEncoded(message, storageManager, buffer);
    }

    private static Message readEncoded(ICoreMessage message, StorageManager storageManager, ActiveMQBuffer buffer) {
        try {
            Message returnMessage = MessagePersister.getInstance().decode(buffer, null, null, storageManager);
            if (returnMessage instanceof LargeServerMessage) {
                ((LargeServerMessage)returnMessage).setStorageManager(storageManager);
            }
            returnMessage.setMessageID(message.getMessageID());
            return returnMessage;
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return message;
        }
    }

    private static Message extractLargeMessage(ICoreMessage message, StorageManager storageManager) {
        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])message.getBytesProperty(AMQP_ENCODE_PROPERTY));
        return EmbedMessageUtil.readEncoded(message, storageManager, buffer);
    }

    private static boolean checkSignature(ActiveMQBuffer buffer) {
        return buffer.readByte() == signature[0] && buffer.readByte() == signature[1] && buffer.readByte() == signature[2];
    }
}

