/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.infinispan.notifications.cachelistener.event.Event;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;

public class ClusteringServerLogger_$logger
extends DelegatingBasicLogger
implements ClusteringServerLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ClusteringServerLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ClusteringServerLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void startSingleton(String service) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startSingleton$str(), (Object)service);
    }

    protected String startSingleton$str() {
        return "WFLYCLSV0001: This node will now operate as the singleton provider of the %s service";
    }

    @Override
    public final void stopSingleton(String service) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stopSingleton$str(), (Object)service);
    }

    protected String stopSingleton$str() {
        return "WFLYCLSV0002: This node will no longer operate as the singleton provider of the %s service";
    }

    @Override
    public final void elected(String node, String service) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.elected$str(), (Object)node, (Object)service);
    }

    protected String elected$str() {
        return "WFLYCLSV0003: %s elected as the singleton provider of the %s service";
    }

    protected String noResponseFromMaster$str() {
        return "WFLYCLSV0004: No response received from master node of the %s service, retrying...";
    }

    @Override
    public final IllegalStateException noResponseFromMaster(String service) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noResponseFromMaster$str(), service));
        ClusteringServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void serviceStartFailed(StartException e, String service) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.serviceStartFailed$str(), (Object)service);
    }

    protected String serviceStartFailed$str() {
        return "WFLYCLSV0005: Failed to start %s service";
    }

    @Override
    public final void quorumNotReached(String service, int quorum) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.quorumNotReached$str(), (Object)service, (Object)quorum);
    }

    protected String quorumNotReached$str() {
        return "WFLYCLSV0006: Failed to reach quorum of %2$d for %1$s service. No singleton master will be elected.";
    }

    @Override
    public final void quorumJustReached(String service, int quorum) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.quorumJustReached$str(), (Object)service, (Object)quorum);
    }

    protected String quorumJustReached$str() {
        return "WFLYCLSV0007: Just reached required quorum of %2$d for %1$s service. If this cluster loses another member, no node will be chosen to provide this service.";
    }

    protected String multiplePrimaryProvidersDetected$str() {
        return "WFLYCLSV0008: Detected multiple primary providers for %s service: %s";
    }

    @Override
    public final IllegalArgumentException multiplePrimaryProvidersDetected(String serviceName, Collection<Node> nodes) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.multiplePrimaryProvidersDetected$str(), serviceName, nodes));
        ClusteringServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notStarted$str() {
        return "WFLYCLSV0009: Singleton service %s is not started.";
    }

    @Override
    public final IllegalStateException notStarted(String serviceName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notStarted$str(), serviceName));
        ClusteringServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void registryPurgeFailed(Throwable e, String containerName, String cacheName, Collection<?> members) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.registryPurgeFailed$str(), (Object)containerName, (Object)cacheName, members);
    }

    protected String registryPurgeFailed$str() {
        return "WFLYCLSV0010: Failed to purge %s/%s registry of old registry entries for: %s";
    }

    @Override
    public final void registryListenerFailed(Throwable e, String containerName, String cacheName, Event.Type type, Map<?, ?> entries) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.registryListenerFailed$str(), new Object[]{containerName, cacheName, type, entries});
    }

    protected String registryListenerFailed$str() {
        return "WFLYCLSV0011: Failed to notify %s/%s registry listener of %s(%s) event";
    }

    @Override
    public final void serviceProviderRegistrationListenerFailed(Throwable e, String containerName, String cacheName, Set<Node> providers) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.serviceProviderRegistrationListenerFailed$str(), (Object)containerName, (Object)cacheName, providers);
    }

    protected String serviceProviderRegistrationListenerFailed$str() {
        return "WFLYCLSV0012: Failed to notify %s/%s service provider registration listener of new providers: %s";
    }

    @Override
    public final void noPrimaryElected(String service) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noPrimaryElected$str(), (Object)service);
    }

    protected String noPrimaryElected$str() {
        return "WFLYCLSV0013: No node was elected as the singleton provider of the %s service";
    }

    protected String invalidQuorum$str() {
        return "WFLYCLSV0014: Specified quorum %d must be greater than zero";
    }

    @Override
    public final IllegalArgumentException invalidQuorum(int quorum) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidQuorum$str(), quorum));
        ClusteringServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToRestoreLocalRegistryEntry(Throwable cause, String containerName, String cacheName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToRestoreLocalRegistryEntry$str(), (Object)containerName, (Object)cacheName);
    }

    protected String failedToRestoreLocalRegistryEntry$str() {
        return "WFLYCLSV0015: Failed to restore local %s/%s registry entry following network partititon merge";
    }

    protected String commandDispatcherAlreadyExists$str() {
        return "WFLYCLSV0016: A command dispatcher already exists for %s";
    }

    @Override
    public final IllegalArgumentException commandDispatcherAlreadyExists(Object id) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.commandDispatcherAlreadyExists$str(), id));
        ClusteringServerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

