/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.wildfly.clustering.marshalling.Externalizer;

public class OptionalLongExternalizer
implements Externalizer<OptionalLong> {
    public void writeObject(ObjectOutput output, OptionalLong value) throws IOException {
        boolean present = value.isPresent();
        output.writeBoolean(present);
        if (present) {
            output.writeLong(value.getAsLong());
        }
    }

    public OptionalLong readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return input.readBoolean() ? OptionalLong.of(input.readLong()) : OptionalLong.empty();
    }

    public OptionalInt size(OptionalLong value) {
        return OptionalInt.of(value.isPresent() ? 9 : 1);
    }

    public Class<OptionalLong> getTargetClass() {
        return OptionalLong.class;
    }
}

