/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import java.sql.Connection;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.impl.table.AbstractTableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

class H2TableManager
extends AbstractTableManager {
    private static final Log log = (Log)LogFactory.getLog(H2TableManager.class, Log.class);

    H2TableManager(InitializationContext ctx, ConnectionFactory connectionFactory, JdbcStringBasedStoreConfiguration config, DbMetaData metaData, String cacheName) {
        super(ctx, connectionFactory, config, metaData, cacheName, log);
    }

    @Override
    protected String initUpsertRowSql() {
        if (this.dbMetadata.isSegmentedDisabled()) {
            return String.format("MERGE INTO %1$s (%2$s, %3$s, %4$s) KEY(%4$s) VALUES(?, ?, ?)", this.dataTableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return String.format("MERGE INTO %1$s (%2$s, %3$s, %4$s, %5$s) KEY(%4$s) VALUES(?, ?, ?, ?)", this.dataTableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.segmentColumnName());
    }

    @Override
    protected void dropIndex(Connection conn, String indexName) throws PersistenceException {
        String dropIndexDdl = String.format("DROP INDEX IF EXISTS  %s", this.getIndexName(true, indexName));
        this.executeUpdateSql(conn, dropIndexDdl);
    }
}

