/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.logging;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class UndertowLogger_$logger
extends DelegatingBasicLogger
implements UndertowLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UndertowLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public UndertowLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void couldNotInitJsp(ClassNotFoundException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.couldNotInitJsp$str(), new Object[0]);
    }

    protected String couldNotInitJsp$str() {
        return "WFLYUT0001: Could not initialize Jakarta Server Pages";
    }

    @Override
    public final void serverStarting(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStarting$str(), (Object)version);
    }

    protected String serverStarting$str() {
        return "WFLYUT0003: Undertow %s starting";
    }

    @Override
    public final void serverStopping(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStopping$str(), (Object)version);
    }

    protected String serverStopping$str() {
        return "WFLYUT0004: Undertow %s stopping";
    }

    @Override
    public final void secureListenerNotAvailableForPort(String protocol) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.secureListenerNotAvailableForPort$str(), (Object)protocol);
    }

    protected String secureListenerNotAvailableForPort$str() {
        return "WFLYUT0005: Secure listener for protocol: '%s' not found! Using non secure port!";
    }

    @Override
    public final void listenerStarted(String type, String name, String address, int port) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.listenerStarted$str(), new Object[]{type, name, address, port});
    }

    protected String listenerStarted$str() {
        return "WFLYUT0006: Undertow %s listener %s listening on %s:%d";
    }

    @Override
    public final void listenerStopped(String type, String name, String address, int port) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.listenerStopped$str(), new Object[]{type, name, address, port});
    }

    protected String listenerStopped$str() {
        return "WFLYUT0007: Undertow %s listener %s stopped, was bound to %s:%d";
    }

    @Override
    public final void listenerSuspend(String type, String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.listenerSuspend$str(), (Object)type, (Object)name);
    }

    protected String listenerSuspend$str() {
        return "WFLYUT0008: Undertow %s listener %s suspending";
    }

    @Override
    public final void cannotLoadDesignatedHandleTypes(ClassInfo classInfo, Exception e) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)e, this.cannotLoadDesignatedHandleTypes$str(), (Object)classInfo);
    }

    protected String cannotLoadDesignatedHandleTypes$str() {
        return "WFLYUT0009: Could not load class designated by HandlesTypes [%s].";
    }

    @Override
    public final void couldNotLoadWebSocketEndpoint(String s, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.couldNotLoadWebSocketEndpoint$str(), (Object)s);
    }

    protected String couldNotLoadWebSocketEndpoint$str() {
        return "WFLYUT0010: Could not load web socket endpoint %s.";
    }

    @Override
    public final void couldNotLoadWebSocketConfig(String s, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.couldNotLoadWebSocketConfig$str(), (Object)s);
    }

    protected String couldNotLoadWebSocketConfig$str() {
        return "WFLYUT0011: Could not load web socket application config %s.";
    }

    @Override
    public final void startedServer(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startedServer$str(), (Object)name);
    }

    protected String startedServer$str() {
        return "WFLYUT0012: Started server %s.";
    }

    @Override
    public final void invalidRedirectURI(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.invalidRedirectURI$str(), new Object[0]);
    }

    protected String invalidRedirectURI$str() {
        return "WFLYUT0013: Could not create redirect URI.";
    }

    @Override
    public final void creatingFileHandler(String path, boolean directoryListing, boolean followSymlink, boolean caseSensitive, List<String> safePaths) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.creatingFileHandler$str(), new Object[]{path, directoryListing, followSymlink, caseSensitive, safePaths});
    }

    protected String creatingFileHandler$str() {
        return "WFLYUT0014: Creating file handler for path '%s' with options [directory-listing: '%s', follow-symlink: '%s', case-sensitive: '%s', safe-symlink-paths: '%s']";
    }

    @Override
    public final void invalidAbsoluteOrdering(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidAbsoluteOrdering$str(), (Object)name);
    }

    protected String invalidAbsoluteOrdering$str() {
        return "WFLYUT0016: Could not resolve name in absolute ordering: %s";
    }

    @Override
    public final void couldNotDeleteTempFile(File file) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.couldNotDeleteTempFile$str(), (Object)file);
    }

    protected String couldNotDeleteTempFile$str() {
        return "WFLYUT0017: Could not delete servlet temp file %s";
    }

    @Override
    public final void hostStarting(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.hostStarting$str(), (Object)version);
    }

    protected String hostStarting$str() {
        return "WFLYUT0018: Host %s starting";
    }

    @Override
    public final void hostStopping(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.hostStopping$str(), (Object)version);
    }

    protected String hostStopping$str() {
        return "WFLYUT0019: Host %s stopping";
    }

    @Override
    public final void clusteringNotSupported() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.clusteringNotSupported$str(), new Object[0]);
    }

    protected String clusteringNotSupported$str() {
        return "WFLYUT0020: Clustering not supported, falling back to non-clustered session manager";
    }

    @Override
    public final void registerWebapp(String webappPath, String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.registerWebapp$str(), (Object)webappPath, (Object)serverName);
    }

    protected String registerWebapp$str() {
        return "WFLYUT0021: Registered web context: '%s' for server '%s'";
    }

    @Override
    public final void unregisterWebapp(String webappPath, String serverName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.unregisterWebapp$str(), (Object)webappPath, (Object)serverName);
    }

    protected String unregisterWebapp$str() {
        return "WFLYUT0022: Unregistered web context: '%s' from server '%s'";
    }

    @Override
    public final void skippedSCI(String jar, Exception e) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)e, this.skippedSCI$str(), (Object)jar);
    }

    protected String skippedSCI$str() {
        return "WFLYUT0023: Skipped SCI for jar: %s.";
    }

    @Override
    public final void failedToPersistSessionAttribute(String attributeName, Object value, String sessionID, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToPersistSessionAttribute$str(), (Object)attributeName, value, (Object)sessionID);
    }

    protected String failedToPersistSessionAttribute$str() {
        return "WFLYUT0024: Failed to persist session attribute %s with value %s for session %s";
    }

    @Override
    public final void failedToRegisterPolicyContextHandler(String key, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToRegisterPolicyContextHandler$str(), (Object)key);
    }

    protected String failedToRegisterPolicyContextHandler$str() {
        return "WFLYUT0025: Failed to register policy context handler for key %s";
    }

    protected String failToParseXMLDescriptor3$str() {
        return "WFLYUT0027: Failed to parse XML descriptor %s at [%s,%s]";
    }

    @Override
    public final String failToParseXMLDescriptor(String xmlFile, Integer line, Integer column) {
        return String.format(this.getLoggingLocale(), this.failToParseXMLDescriptor3$str(), xmlFile, line, column);
    }

    protected String failToParseXMLDescriptor1$str() {
        return "WFLYUT0028: Failed to parse XML descriptor %s";
    }

    @Override
    public final String failToParseXMLDescriptor(String xmlFile) {
        return String.format(this.getLoggingLocale(), this.failToParseXMLDescriptor1$str(), xmlFile);
    }

    protected String invalidWebServletAnnotation$str() {
        return "WFLYUT0029: @WebServlet is only allowed at class level %s";
    }

    @Override
    public final String invalidWebServletAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidWebServletAnnotation$str(), target);
    }

    protected String invalidWebInitParamAnnotation$str() {
        return "WFLYUT0030: @WebInitParam requires name and value on %s";
    }

    @Override
    public final String invalidWebInitParamAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidWebInitParamAnnotation$str(), target);
    }

    protected String invalidWebFilterAnnotation$str() {
        return "WFLYUT0031: @WebFilter is only allowed at class level %s";
    }

    @Override
    public final String invalidWebFilterAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidWebFilterAnnotation$str(), target);
    }

    protected String invalidWebListenerAnnotation$str() {
        return "WFLYUT0032: @WebListener is only allowed at class level %s";
    }

    @Override
    public final String invalidWebListenerAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidWebListenerAnnotation$str(), target);
    }

    protected String invalidRunAsAnnotation$str() {
        return "WFLYUT0033: @RunAs needs to specify a role name on %s";
    }

    @Override
    public final String invalidRunAsAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidRunAsAnnotation$str(), target);
    }

    protected String invalidDeclareRolesAnnotation$str() {
        return "WFLYUT0034: @DeclareRoles needs to specify role names on %s";
    }

    @Override
    public final String invalidDeclareRolesAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidDeclareRolesAnnotation$str(), target);
    }

    protected String invalidMultipartConfigAnnotation$str() {
        return "WFLYUT0035: @MultipartConfig is only allowed at class level %s";
    }

    @Override
    public final String invalidMultipartConfigAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidMultipartConfigAnnotation$str(), target);
    }

    protected String invalidServletSecurityAnnotation$str() {
        return "WFLYUT0036: @ServletSecurity is only allowed at class level %s";
    }

    @Override
    public final String invalidServletSecurityAnnotation(AnnotationTarget target) {
        return String.format(this.getLoggingLocale(), this.invalidServletSecurityAnnotation$str(), target);
    }

    protected String wrongComponentType$str() {
        return "WFLYUT0037: %s has the wrong component type, it cannot be used as a web component";
    }

    @Override
    public final RuntimeException wrongComponentType(String clazz) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.wrongComponentType$str(), clazz));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String tldFileNotContainedInRoot$str() {
        return "WFLYUT0038: TLD file %s not contained in root %s";
    }

    @Override
    public final String tldFileNotContainedInRoot(String tldPath, String rootPath) {
        return String.format(this.getLoggingLocale(), this.tldFileNotContainedInRoot$str(), tldPath, rootPath);
    }

    protected String failedToResolveModule$str() {
        return "WFLYUT0039: Failed to resolve module for deployment %s";
    }

    @Override
    public final DeploymentUnitProcessingException failedToResolveModule(DeploymentUnit deploymentUnit) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToResolveModule$str(), deploymentUnit));
        UndertowLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidMultipleOthers$str() {
        return "WFLYUT0040: Duplicate others in absolute ordering";
    }

    @Override
    public final String invalidMultipleOthers() {
        return String.format(this.getLoggingLocale(), this.invalidMultipleOthers$str(), new Object[0]);
    }

    protected String invalidRelativeOrdering0$str() {
        return "WFLYUT0041: Invalid relative ordering";
    }

    @Override
    public final String invalidRelativeOrdering() {
        return String.format(this.getLoggingLocale(), this.invalidRelativeOrdering0$str(), new Object[0]);
    }

    protected String invalidWebFragment$str() {
        return "WFLYUT0042: Conflict occurred processing web fragment in JAR: %s";
    }

    @Override
    public final String invalidWebFragment(String jar) {
        return String.format(this.getLoggingLocale(), this.invalidWebFragment$str(), jar);
    }

    protected String invalidRelativeOrdering1$str() {
        return "WFLYUT0043: Relative ordering processing error with JAR: %s";
    }

    @Override
    public final String invalidRelativeOrdering(String jar) {
        return String.format(this.getLoggingLocale(), this.invalidRelativeOrdering1$str(), jar);
    }

    protected String invalidRelativeOrderingBeforeAndAfter$str() {
        return "WFLYUT0044: Ordering includes both before and after others in JAR: %s";
    }

    @Override
    public final String invalidRelativeOrderingBeforeAndAfter(String jar) {
        return String.format(this.getLoggingLocale(), this.invalidRelativeOrderingBeforeAndAfter$str(), jar);
    }

    protected String invalidRelativeOrderingDuplicateName$str() {
        return "WFLYUT0045: Duplicate name declared in JAR: %s";
    }

    @Override
    public final String invalidRelativeOrderingDuplicateName(String jar) {
        return String.format(this.getLoggingLocale(), this.invalidRelativeOrderingDuplicateName$str(), jar);
    }

    @Override
    public final void invalidRelativeOrderingUnknownName(String jar) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidRelativeOrderingUnknownName$str(), (Object)jar);
    }

    protected String invalidRelativeOrderingUnknownName$str() {
        return "WFLYUT0046: Unknown web fragment name declared in JAR: %s";
    }

    protected String invalidRelativeOrderingConflict$str() {
        return "WFLYUT0047: Relative ordering conflict with JAR: %s";
    }

    @Override
    public final String invalidRelativeOrderingConflict(String jar) {
        return String.format(this.getLoggingLocale(), this.invalidRelativeOrderingConflict$str(), jar);
    }

    protected String failToProcessWebInfLib$str() {
        return "WFLYUT0048: Failed to process WEB-INF/lib: %s";
    }

    @Override
    public final String failToProcessWebInfLib(VirtualFile xmlFile) {
        return String.format(this.getLoggingLocale(), this.failToProcessWebInfLib$str(), xmlFile);
    }

    protected String errorLoadingSCIFromModule$str() {
        return "WFLYUT0049: Error loading SCI from module: %s";
    }

    @Override
    public final DeploymentUnitProcessingException errorLoadingSCIFromModule(String identifier, Exception e) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.errorLoadingSCIFromModule$str(), identifier), (Throwable)e);
        UndertowLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToResolveAnnotationIndex$str() {
        return "WFLYUT0050: Unable to resolve annotation index for deployment unit: %s";
    }

    @Override
    public final DeploymentUnitProcessingException unableToResolveAnnotationIndex(DeploymentUnit deploymentUnit) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.unableToResolveAnnotationIndex$str(), deploymentUnit));
        UndertowLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorProcessingSCI$str() {
        return "WFLYUT0051: Deployment error processing SCI for jar: %s";
    }

    @Override
    public final DeploymentUnitProcessingException errorProcessingSCI(String jar, Exception e) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.errorProcessingSCI$str(), jar), (Throwable)e);
        UndertowLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failToCreateSecurityContext$str() {
        return "WFLYUT0052: Security context creation failed";
    }

    @Override
    public final RuntimeException failToCreateSecurityContext(Throwable t) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failToCreateSecurityContext$str(), new Object[0]), t);
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSecurityContext$str() {
        return "WFLYUT0053: No security context found";
    }

    @Override
    public final IllegalStateException noSecurityContext() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noSecurityContext$str(), new Object[0]));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownMetric$str() {
        return "WFLYUT0054: Unknown metric %s";
    }

    @Override
    public final String unknownMetric(Object metric) {
        return String.format(this.getLoggingLocale(), this.unknownMetric$str(), metric);
    }

    protected String nullDefaultHost$str() {
        return "WFLYUT0055: Null default host";
    }

    @Override
    public final IllegalArgumentException nullDefaultHost() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullDefaultHost$str(), new Object[0]));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullHostName$str() {
        return "WFLYUT0056: Null host name";
    }

    @Override
    public final IllegalStateException nullHostName() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.nullHostName$str(), new Object[0]));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullParamter$str() {
        return "WFLYUT0057: Null parameter %s";
    }

    @Override
    public final IllegalArgumentException nullParamter(String id) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullParamter$str(), id));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotActivateContext$str() {
        return "WFLYUT0058: Cannot activate context: %s";
    }

    @Override
    public final IllegalStateException cannotActivateContext(Throwable th, ServiceName service) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotActivateContext$str(), service), th);
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateHttpHandler$str() {
        return "WFLYUT0059: Could not construct handler for class: %s. with parameters %s";
    }

    @Override
    public final RuntimeException cannotCreateHttpHandler(Class<?> handlerClass, ModelNode parameters, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotCreateHttpHandler$str(), handlerClass, parameters), cause);
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPersistentSessionDir$str() {
        return "WFLYUT0060: Invalid persistent sessions directory %s";
    }

    @Override
    public final StartException invalidPersistentSessionDir(File baseDir) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.invalidPersistentSessionDir$str(), baseDir));
        UndertowLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToCreatePersistentSessionDir$str() {
        return "WFLYUT0061: Failed to create persistent sessions dir %s";
    }

    @Override
    public final StartException failedToCreatePersistentSessionDir(File baseDir) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToCreatePersistentSessionDir$str(), baseDir));
        UndertowLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotCreateLogDirectory$str() {
        return "WFLYUT0062: Could not create log directory: %s";
    }

    @Override
    public final StartException couldNotCreateLogDirectory(Path directory, IOException e) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.couldNotCreateLogDirectory$str(), directory), (Throwable)e);
        UndertowLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noPortListeningForProtocol$str() {
        return "WFLYUT0063: Could not find the port number listening for protocol %s";
    }

    @Override
    public final IllegalStateException noPortListeningForProtocol(String protocol) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noPortListeningForProtocol$str(), protocol));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToConfigureHandler$str() {
        return "WFLYUT0064: Failed to configure handler %s";
    }

    @Override
    public final RuntimeException failedToConfigureHandler(Class<?> handlerClass, Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToConfigureHandler$str(), handlerClass), e);
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String handlerWasNotAHandlerOrWrapper$str() {
        return "WFLYUT0065: Handler class %s was not a handler or a wrapper";
    }

    @Override
    public final IllegalArgumentException handlerWasNotAHandlerOrWrapper(Class<?> handlerClass) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.handlerWasNotAHandlerOrWrapper$str(), handlerClass));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToConfigureHandlerClass$str() {
        return "WFLYUT0066: Failed to configure handler %s";
    }

    @Override
    public final RuntimeException failedToConfigureHandlerClass(String handlerClass, Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToConfigureHandlerClass$str(), handlerClass), e);
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String servletClassNotDefined$str() {
        return "WFLYUT0067: Servlet class not defined for servlet %s";
    }

    @Override
    public final IllegalArgumentException servletClassNotDefined(String servletName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.servletClassNotDefined$str(), servletName));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void noAuthorizationHelper(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.noAuthorizationHelper$str(), new Object[0]);
    }

    protected String noAuthorizationHelper$str() {
        return "WFLYUT0068: Error obtaining authorization helper";
    }

    @Override
    public final void sharedSessionConfigNotInRootDeployment(String deployment) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.sharedSessionConfigNotInRootDeployment$str(), (Object)deployment);
    }

    protected String sharedSessionConfigNotInRootDeployment$str() {
        return "WFLYUT0069: Ignoring shared-session-config in jboss-all.xml in deployment %s. This entry is only valid in top level deployments.";
    }

    protected String couldNotLoadHandlerFromModule$str() {
        return "WFLYUT0070: Could not load handler %s from %s module";
    }

    @Override
    public final RuntimeException couldNotLoadHandlerFromModule(String className, String moduleName, Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotLoadHandlerFromModule$str(), className, moduleName), e);
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void alpnNotFound(String listener) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.alpnNotFound$str(), (Object)listener);
    }

    protected String alpnNotFound$str() {
        return "WFLYUT0071: No ALPN provider found, HTTP/2 will not be enabled. To remove this message set enable-http2 to false on the listener %s in the Undertow subsystem.";
    }

    protected String couldNotFindExternalPath$str() {
        return "WFLYUT0072: Could not find configured external path %s";
    }

    @Override
    public final DeploymentUnitProcessingException couldNotFindExternalPath(File path) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotFindExternalPath$str(), path));
        UndertowLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String advertiseSocketBindingRequiresMulticastAddress$str() {
        return "WFLYUT0073: mod_cluster advertise socket binding requires multicast address to be set";
    }

    @Override
    public final StartException advertiseSocketBindingRequiresMulticastAddress() {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.advertiseSocketBindingRequiresMulticastAddress$str(), new Object[0]));
        UndertowLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void tldNotFound(String location) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.tldNotFound$str(), (Object)location);
    }

    protected String tldNotFound$str() {
        return "WFLYUT0074: Could not find TLD %s";
    }

    protected String cannotRegisterResourceOfType$str() {
        return "WFLYUT0075: Cannot register resource of type %s";
    }

    @Override
    public final IllegalArgumentException cannotRegisterResourceOfType(String type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotRegisterResourceOfType$str(), type));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemoveResourceOfType$str() {
        return "WFLYUT0076: Cannot remove resource of type %s";
    }

    @Override
    public final IllegalArgumentException cannotRemoveResourceOfType(String type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotRemoveResourceOfType$str(), type));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToRegisterWebsocket(Class endpoint, String path, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToRegisterWebsocket$str(), (Object)endpoint, (Object)path);
    }

    protected String failedToRegisterWebsocket$str() {
        return "WFLYUT0078: Failed to register management view for websocket %s at %s";
    }

    @Override
    public final void errorInvokingSecureResponse(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorInvokingSecureResponse$str(), new Object[0]);
    }

    protected String errorInvokingSecureResponse$str() {
        return "WFLYUT0077: Error invoking secure response";
    }

    protected String noSslContextInSecurityRealm$str() {
        return "WFLYUT0079: No SSL Context available from security realm '%s'. Either the realm is not configured for SSL, or the server has not been reloaded since the SSL config was added.";
    }

    @Override
    public final IllegalStateException noSslContextInSecurityRealm(String securityRealm) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noSslContextInSecurityRealm$str(), securityRealm));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unsupportedValveFeature(String valve) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsupportedValveFeature$str(), (Object)valve);
    }

    protected String unsupportedValveFeature$str() {
        return "WFLYUT0080: Valves are no longer supported, %s is not activated.";
    }

    @Override
    public final void distributableDisabledInFragmentXml(String deployment, String module) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.distributableDisabledInFragmentXml$str(), (Object)deployment, (Object)module);
    }

    protected String distributableDisabledInFragmentXml$str() {
        return "WFLYUT0081: The deployment %s will not be distributable because this feature is disabled in web-fragment.xml of the module %s.";
    }

    protected String couldNotStartListener$str() {
        return "WFLYUT0082: Could not start '%s' listener.";
    }

    @Override
    public final StartException couldNotStartListener(String name, IOException e) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.couldNotStartListener$str(), name), (Throwable)e);
        UndertowLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullNotAllowed$str() {
        return "WFLYUT0083: %s is not allowed to be null";
    }

    @Override
    public final String nullNotAllowed(String name) {
        return String.format(this.getLoggingLocale(), this.nullNotAllowed$str(), name);
    }

    protected String duplicateDefaultWebModuleMapping$str() {
        return "WFLYUT0087: Duplicate default web module '%s' configured on server '%s', host '%s'";
    }

    @Override
    public final IllegalArgumentException duplicateDefaultWebModuleMapping(String defaultDeploymentName, String serverName, String hostName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.duplicateDefaultWebModuleMapping$str(), defaultDeploymentName, serverName, hostName));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String predicateNotValid$str() {
        return "WFLYUT0089: Predicate %s was not valid, message was: %s";
    }

    @Override
    public final String predicateNotValid(String predicate, String error) {
        return String.format(this.getLoggingLocale(), this.predicateNotValid$str(), predicate, error);
    }

    protected String missingKeyStoreEntry$str() {
        return "WFLYUT0090: Key alias %s does not exist in the configured key store";
    }

    @Override
    public final IllegalArgumentException missingKeyStoreEntry(String alias) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingKeyStoreEntry$str(), alias));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyStoreEntryNotPrivate$str() {
        return "WFLYUT0091: Key store entry %s is not a private key entry";
    }

    @Override
    public final IllegalArgumentException keyStoreEntryNotPrivate(String alias) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.keyStoreEntryNotPrivate$str(), alias));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingCredential$str() {
        return "WFLYUT0092: Credential alias %s does not exist in the configured credential store";
    }

    @Override
    public final IllegalArgumentException missingCredential(String alias) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingCredential$str(), alias));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String credentialNotClearPassword$str() {
        return "WFLYUT0093: Credential %s is not a clear text password";
    }

    @Override
    public final IllegalArgumentException credentialNotClearPassword(String alias) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.credentialNotClearPassword$str(), alias));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void configurationOptionIgnoredWhenUsingElytron(String option) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.configurationOptionIgnoredWhenUsingElytron$str(), (Object)option);
    }

    protected String configurationOptionIgnoredWhenUsingElytron$str() {
        return "WFLYUT0094: Configuration option [%s] ignored when using Elytron subsystem";
    }

    protected String unableAddHandlerForPath$str() {
        return "WFLYUT0095: the path ['%s'] doesn't exist on file system";
    }

    @Override
    public final String unableAddHandlerForPath(String path) {
        return String.format(this.getLoggingLocale(), this.unableAddHandlerForPath$str(), path);
    }

    protected String workerValueInHTTPListenerMustMatchRemoting$str() {
        return "WFLYUT0097: If http-upgrade is enabled, remoting worker and http(s) worker must be the same. Please adjust values if need be.";
    }

    @Override
    public final String workerValueInHTTPListenerMustMatchRemoting() {
        return String.format(this.getLoggingLocale(), this.workerValueInHTTPListenerMustMatchRemoting$str(), new Object[0]);
    }

    @Override
    public final void unexceptedAuthentificationError(String errorMessage, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unexceptedAuthentificationError$str(), (Object)errorMessage);
    }

    protected String unexceptedAuthentificationError$str() {
        return "WFLYUT0098: Unexpected Authentication Error: %s";
    }

    protected String sessionManagerNotAvailable$str() {
        return "WFLYUT0099: Session manager not available";
    }

    @Override
    public final OperationFailedException sessionManagerNotAvailable() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.sessionManagerNotAvailable$str(), new Object[0]));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sessionNotFound$str() {
        return "WFLYUT0100: Session %s not found";
    }

    @Override
    public final OperationFailedException sessionNotFound(String sessionId) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.sessionNotFound$str(), sessionId));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void duplicateServletMapping(String mapping) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.duplicateServletMapping$str(), (Object)mapping);
    }

    protected String duplicateServletMapping$str() {
        return "WFLYUT0101: Duplicate servlet mapping %s found";
    }

    protected String invalidDateTimeFormatterPattern$str() {
        return "WFLYUT0102: The pattern %s is not a valid date pattern.";
    }

    @Override
    public final OperationFailedException invalidDateTimeFormatterPattern(String pattern) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidDateTimeFormatterPattern$str(), pattern));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTimeZoneId$str() {
        return "WFLYUT0103: The time zone id %s is invalid.";
    }

    @Override
    public final OperationFailedException invalidTimeZoneId(String zoneId) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidTimeZoneId$str(), zoneId));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingClassInAnnotation$str() {
        return "WFLYUT0104: Some classes referenced by annotation: %s in class: %s are missing.";
    }

    @Override
    public final DeploymentUnitProcessingException missingClassInAnnotation(String anCls, String resCls) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.missingClassInAnnotation$str(), anCls, resCls));
        UndertowLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicateHostContextDeployments$str() {
        return "WFLYUT0105: Host and context path are occupied, %s can't be registered. Message was: %s";
    }

    @Override
    public final DuplicateServiceException duplicateHostContextDeployments(ServiceName deploymentInfoServiceName, String errorMessage) {
        DuplicateServiceException result = new DuplicateServiceException(String.format(this.getLoggingLocale(), this.duplicateHostContextDeployments$str(), deploymentInfoServiceName, errorMessage));
        UndertowLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unableToObfuscateSessionRoute(String route, NoSuchAlgorithmException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.unableToObfuscateSessionRoute$str(), (Object)route);
    }

    protected String unableToObfuscateSessionRoute$str() {
        return "WFLYUT0106: Unable to generate obfuscated session route from '%s'";
    }

    @Override
    public final void obfuscatedSessionRoute(String obfuscatedRoute, String route) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.obfuscatedSessionRoute$str(), (Object)obfuscatedRoute, (Object)route);
    }

    protected String obfuscatedSessionRoute$str() {
        return "WFLYUT0107: Generated obfuscated session route '%s' from '%s'";
    }

    protected String deploymentConfiguredForLegacySecurity$str() {
        return "WFLYUT0108: The deployment is configured to use legacy security which is no longer available.";
    }

    @Override
    public final DeploymentUnitProcessingException deploymentConfiguredForLegacySecurity() {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.deploymentConfiguredForLegacySecurity$str(), new Object[0]));
        UndertowLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

