/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.listener;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiConsumer;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.util.concurrent.CompletableFutures;

@Listener(observation=Listener.Observation.PRE)
public class PrePassivateListener<K, V> {
    private final BiConsumer<K, V> consumer;
    private final Executor executor;

    public PrePassivateListener(BiConsumer<K, V> consumer, Executor executor) {
        this.consumer = consumer;
        this.executor = executor;
    }

    @CacheEntryPassivated
    public CompletionStage<Void> passivated(CacheEntryPassivatedEvent<K, V> event) {
        if (event.isPre()) {
            try {
                return CompletableFuture.runAsync(() -> this.consumer.accept(event.getKey(), event.getValue()), this.executor);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return CompletableFutures.completedNull();
    }
}

