/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DeprecatedResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.extension.AbstractLegacyExtension;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.security.ACLResourceDefinition;
import org.jboss.as.security.AuditResourceDefinition;
import org.jboss.as.security.AuthorizationResourceDefinition;
import org.jboss.as.security.ClassicAuthenticationResourceDefinition;
import org.jboss.as.security.IdentityTrustResourceDefinition;
import org.jboss.as.security.JASPIAuthenticationResourceDefinition;
import org.jboss.as.security.JSSEResourceDefinition;
import org.jboss.as.security.MappingResourceDefinition;
import org.jboss.as.security.Namespace;
import org.jboss.as.security.SecurityDomainResourceDefinition;
import org.jboss.as.security.SecuritySubsystemParser;
import org.jboss.as.security.SecuritySubsystemParser_2_0;
import org.jboss.as.security.SecuritySubsystemPersister;
import org.jboss.as.security.SecuritySubsystemRootResourceDefinition;
import org.jboss.as.security.VaultResourceDefinition;
import org.jboss.as.security.elytron.ElytronIntegrationResourceDefinitions;
import org.jboss.staxmapper.XMLElementWriter;

public class SecurityExtension
extends AbstractLegacyExtension {
    public static final String SUBSYSTEM_NAME = "security";
    static final PathElement PATH_SUBSYSTEM = PathElement.pathElement((String)"subsystem", (String)"security");
    private static final String RESOURCE_NAME = SecurityExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)2, (int)0, (int)0);
    static final PathElement ACL_PATH = PathElement.pathElement((String)"acl", (String)"classic");
    static final PathElement PATH_JASPI_AUTH = PathElement.pathElement((String)"authentication", (String)"jaspi");
    static final PathElement PATH_CLASSIC_AUTHENTICATION = PathElement.pathElement((String)"authentication", (String)"classic");
    static final PathElement SECURITY_DOMAIN_PATH = PathElement.pathElement((String)"security-domain");
    static final PathElement PATH_AUTHORIZATION_CLASSIC = PathElement.pathElement((String)"authorization", (String)"classic");
    static final PathElement PATH_MAPPING_CLASSIC = PathElement.pathElement((String)"mapping", (String)"classic");
    static final PathElement PATH_AUDIT_CLASSIC = PathElement.pathElement((String)"audit", (String)"classic");
    static final PathElement PATH_LOGIN_MODULE_STACK = PathElement.pathElement((String)"login-module-stack");
    static final PathElement VAULT_PATH = PathElement.pathElement((String)"vault", (String)"classic");
    static final PathElement JSSE_PATH = PathElement.pathElement((String)"jsse", (String)"classic");
    static final ModelVersion DEPRECATED_SINCE = ModelVersion.create((int)1, (int)3, (int)0);

    public SecurityExtension() {
        super("org.jboss.as.security.SecurityExtension", new String[]{SUBSYSTEM_NAME});
    }

    public static StandardResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new DeprecatedResourceDescriptionResolver(SUBSYSTEM_NAME, keyPrefix, RESOURCE_NAME, SecurityExtension.class.getClassLoader(), true, true);
    }

    public static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder();
        for (String kp : keyPrefix) {
            if (prefix.length() > 0) {
                prefix.append('.');
            }
            prefix.append(kp);
        }
        return new DeprecatedResourceDescriptionResolver(SUBSYSTEM_NAME, prefix.toString(), RESOURCE_NAME, SecurityExtension.class.getClassLoader(), true, false);
    }

    protected Set<ManagementResourceRegistration> initializeLegacyModel(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION, true);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)SecuritySubsystemRootResourceDefinition.INSTANCE);
        ManagementResourceRegistration securityDomain = registration.registerSubModel((ResourceDefinition)new SecurityDomainResourceDefinition());
        securityDomain.registerSubModel((ResourceDefinition)JASPIAuthenticationResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)ClassicAuthenticationResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)AuthorizationResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)MappingResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)ACLResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)AuditResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)IdentityTrustResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)JSSEResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)VaultResourceDefinition.INSTANCE);
        registration.registerSubModel(ElytronIntegrationResourceDefinitions.getElytronRealmResourceDefinition());
        registration.registerSubModel(ElytronIntegrationResourceDefinitions.getElytronKeyStoreResourceDefinition());
        registration.registerSubModel(ElytronIntegrationResourceDefinitions.getElytronTrustStoreResourceDefinition());
        registration.registerSubModel(ElytronIntegrationResourceDefinitions.getElytronKeyManagersResourceDefinition());
        registration.registerSubModel(ElytronIntegrationResourceDefinitions.getElytronTrustManagersResourceDefinition());
        subsystem.registerXMLElementWriter((XMLElementWriter)SecuritySubsystemPersister.INSTANCE);
        return Collections.singleton(registration);
    }

    protected void initializeLegacyParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.SECURITY_1_0.getUriString(), SecuritySubsystemParser::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.SECURITY_1_1.getUriString(), SecuritySubsystemParser::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.SECURITY_1_2.getUriString(), SecuritySubsystemParser::new);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.SECURITY_2_0.getUriString(), SecuritySubsystemParser_2_0::new);
    }
}

