/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.messagedriven;

import java.beans.IntrospectionException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponent;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.common.beans.property.BeanUtils;
import org.jboss.jca.core.spi.rar.Activation;
import org.jboss.jca.core.spi.rar.Endpoint;
import org.jboss.jca.core.spi.rar.MessageListener;
import org.jboss.jca.core.spi.rar.NotFoundException;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;

public class MessageDrivenComponentCreateService
extends EJBComponentCreateService {
    private final Class<?> messageListenerInterface;
    private final Properties activationProps;
    private final String resourceAdapterName;
    private final boolean deliveryActive;
    private final ServiceName deliveryControllerName;
    private final InjectedValue<ResourceAdapterRepository> resourceAdapterRepositoryInjectedValue = new InjectedValue();
    private final InjectedValue<ResourceAdapter> resourceAdapterInjectedValue = new InjectedValue();
    private final InjectedValue<PoolConfig> poolConfig = new InjectedValue();
    private final InjectedValue<SuspendController> suspendControllerInjectedValue = new InjectedValue();
    private final ClassLoader moduleClassLoader;

    public MessageDrivenComponentCreateService(ComponentConfiguration componentConfiguration, ApplicationExceptions ejbJarConfiguration, Class<?> messageListenerInterface) {
        super(componentConfiguration, ejbJarConfiguration);
        MessageDrivenComponentDescription componentDescription = (MessageDrivenComponentDescription)componentConfiguration.getComponentDescription();
        this.resourceAdapterName = componentDescription.getResourceAdapterName();
        this.deliveryControllerName = componentDescription.isDeliveryControlled() ? componentDescription.getDeliveryControllerName() : null;
        this.deliveryActive = !componentDescription.isDeliveryControlled() && componentDescription.isDeliveryActive();
        this.messageListenerInterface = messageListenerInterface;
        this.activationProps = componentDescription.getActivationProps();
        this.moduleClassLoader = componentConfiguration.getModuleClassLoader();
    }

    public void start(StartContext context) throws StartException {
        super.start(context);
        EjbLogger.ROOT_LOGGER.logMDBStart(this.getComponentName(), this.resourceAdapterName);
    }

    protected BasicComponent createComponent() {
        String configuredResourceAdapterName = this.resourceAdapterName;
        String activeResourceAdapterName = this.searchActiveResourceAdapterName(configuredResourceAdapterName);
        ActivationSpec activationSpec = this.createActivationSpecs(activeResourceAdapterName, this.messageListenerInterface, this.activationProps, this.getDeploymentClassLoader());
        MessageDrivenComponent component = new MessageDrivenComponent(this, this.messageListenerInterface, activationSpec, this.deliveryActive, this.deliveryControllerName, activeResourceAdapterName);
        Endpoint endpoint = this.getEndpoint(activeResourceAdapterName);
        component.setEndpoint(endpoint);
        return component;
    }

    private ActivationSpec createActivationSpecs(String resourceAdapterName, Class<?> messageListenerInterface, Properties activationConfigProperties, ClassLoader classLoader) {
        try {
            String raIdentifier = ConnectorServices.getRegisteredResourceAdapterIdentifier((String)resourceAdapterName);
            if (raIdentifier == null) {
                throw EjbLogger.ROOT_LOGGER.unknownResourceAdapter(resourceAdapterName);
            }
            ResourceAdapterRepository resourceAdapterRepository = (ResourceAdapterRepository)this.resourceAdapterRepositoryInjectedValue.getValue();
            if (resourceAdapterRepository == null) {
                throw EjbLogger.ROOT_LOGGER.resourceAdapterRepositoryUnAvailable();
            }
            List messageListeners = resourceAdapterRepository.getMessageListeners(raIdentifier);
            if (messageListeners == null || messageListeners.isEmpty()) {
                throw EjbLogger.ROOT_LOGGER.unknownMessageListenerType(messageListenerInterface.getName(), resourceAdapterName);
            }
            MessageListener requiredMessageListener = null;
            for (MessageListener messageListener : messageListeners) {
                if (!messageListenerInterface.equals(messageListener.getType())) continue;
                requiredMessageListener = messageListener;
                break;
            }
            if (requiredMessageListener == null) {
                throw EjbLogger.ROOT_LOGGER.unknownMessageListenerType(messageListenerInterface.getName(), resourceAdapterName);
            }
            Activation activation = requiredMessageListener.getActivation();
            Properties validActivationConfigProps = this.filterUnknownActivationConfigProperties(resourceAdapterName, activation, activationConfigProperties);
            ActivationSpec activationSpec = activation.createInstance();
            BeanUtils.mapJavaBeanProperties((Object)activationSpec, (Properties)validActivationConfigProps);
            return activationSpec;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    private Properties filterUnknownActivationConfigProperties(String resourceAdapterName, Activation activation, Properties activationConfigProps) {
        if (activationConfigProps == null) {
            return null;
        }
        Map raActivationConfigProps = activation.getConfigProperties();
        Set raRequiredConfigProps = activation.getRequiredConfigProperties();
        Enumeration<?> propNames = activationConfigProps.propertyNames();
        Properties validActivationConfigProps = new Properties();
        validActivationConfigProps.putAll((Map<?, ?>)activationConfigProps);
        while (propNames.hasMoreElements()) {
            Object propName = propNames.nextElement();
            if (raActivationConfigProps.containsKey(propName) || raRequiredConfigProps.contains(propName)) continue;
            validActivationConfigProps.remove(propName);
            EjbLogger.ROOT_LOGGER.activationConfigPropertyIgnored(propName, resourceAdapterName);
        }
        return validActivationConfigProps;
    }

    private Endpoint getEndpoint(String resourceAdapterName) {
        String raIdentifier = ConnectorServices.getRegisteredResourceAdapterIdentifier((String)resourceAdapterName);
        if (raIdentifier == null) {
            throw EjbLogger.ROOT_LOGGER.unknownResourceAdapter(resourceAdapterName);
        }
        ResourceAdapterRepository resourceAdapterRepository = (ResourceAdapterRepository)this.resourceAdapterRepositoryInjectedValue.getValue();
        if (resourceAdapterRepository == null) {
            throw EjbLogger.ROOT_LOGGER.resourceAdapterRepositoryUnAvailable();
        }
        try {
            return resourceAdapterRepository.getEndpoint(raIdentifier);
        }
        catch (NotFoundException nfe) {
            throw EjbLogger.ROOT_LOGGER.noSuchEndpointException(resourceAdapterName, nfe);
        }
    }

    private String searchActiveResourceAdapterName(String configuredResourceAdapterName) {
        Object result = configuredResourceAdapterName;
        if (configuredResourceAdapterName != null && ConnectorServices.getRegisteredResourceAdapterIdentifier((String)configuredResourceAdapterName) == null) {
            Object amended = this.stripDotRarSuffix(configuredResourceAdapterName);
            if (configuredResourceAdapterName.equals(amended)) {
                amended = configuredResourceAdapterName + ".rar";
            }
            if (ConnectorServices.getRegisteredResourceAdapterIdentifier((String)amended) != null) {
                result = amended;
            }
        }
        return result;
    }

    PoolConfig getPoolConfig() {
        return (PoolConfig)this.poolConfig.getOptionalValue();
    }

    public InjectedValue<PoolConfig> getPoolConfigInjector() {
        return this.poolConfig;
    }

    private ClassLoader getDeploymentClassLoader() {
        return this.getComponentClass().getClassLoader();
    }

    public InjectedValue<ResourceAdapterRepository> getResourceAdapterRepositoryInjector() {
        return this.resourceAdapterRepositoryInjectedValue;
    }

    public InjectedValue<ResourceAdapter> getResourceAdapterInjector() {
        return this.resourceAdapterInjectedValue;
    }

    public ClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    public InjectedValue<SuspendController> getSuspendControllerInjectedValue() {
        return this.suspendControllerInjectedValue;
    }

    private String stripDotRarSuffix(String raName) {
        if (raName == null) {
            return null;
        }
        if (raName.endsWith(".rar")) {
            return raName.substring(0, raName.indexOf(".rar"));
        }
        return raName;
    }
}

