/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.io.IOException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ApplicationSecurityDomain;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SSLSecurityBuilder;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.dmr.ModelNode;

public class HTTPServer {
    public static final String DEFAULT_SERVER = "default-server";

    public static void enableSSL(String serverName, boolean addHttpsListener, final String listenerName, String socketBinding, boolean noOverride, CommandContext context, SSLSecurityBuilder builder) throws OperationFormatException, IOException {
        if (serverName == null) {
            serverName = DefaultResourceNames.getDefaultServerName(context);
        }
        if (serverName == null) {
            throw new OperationFormatException("No default server name found.");
        }
        final String sName = serverName;
        if (addHttpsListener) {
            if (!HTTPServer.hasHttpsListener(context, serverName, listenerName)) {
                builder.addStep(HTTPServer.addHttpsListener(serverName, listenerName, socketBinding, builder.getServerSSLContext().getName()), new SSLSecurityBuilder.FailureDescProvider(){

                    @Override
                    public String stepFailedDescription() {
                        return "Adding https-listener " + listenerName + " to server " + sName;
                    }
                });
            } else {
                builder.addStep(HTTPServer.writeServerAttribute(serverName, listenerName, "ssl-context", builder.getServerSSLContext().getName()), new SSLSecurityBuilder.FailureDescProvider(){

                    @Override
                    public String stepFailedDescription() {
                        return "Writing ssl-context attribute on https-listener " + sName;
                    }
                });
            }
        } else {
            builder.addStep(HTTPServer.writeServerAttribute(serverName, listenerName, "ssl-context", builder.getServerSSLContext().getName()), new SSLSecurityBuilder.FailureDescProvider(){

                @Override
                public String stepFailedDescription() {
                    return "Writing ssl-context attribute on https-listener " + sName;
                }
            });
        }
        if (!noOverride && HTTPServer.isLegacySecurityRealmSupported(context)) {
            builder.addStep(HTTPServer.writeServerAttribute(serverName, listenerName, "security-realm", null), new SSLSecurityBuilder.FailureDescProvider(){

                @Override
                public String stepFailedDescription() {
                    return "Writing security-realm attribute on http-server " + sName;
                }
            });
        }
    }

    private static ModelNode writeServerAttribute(String serverName, String httpsListener, String name, String value) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("write-attribute");
        builder.addNode("subsystem", "undertow");
        builder.addNode("server", serverName);
        builder.addNode("https-listener", httpsListener);
        builder.addProperty("name", name);
        if (value != null) {
            builder.addProperty("value", value);
        }
        return builder.buildRequest();
    }

    public static String disableSSL(CommandContext context, String serverName, boolean removeHttpsListener, String httpsListener, String defaultAppSSLContext, ModelNode steps) throws OperationFormatException, IOException {
        if (serverName == null) {
            serverName = DefaultResourceNames.getDefaultServerName(context);
        }
        if (removeHttpsListener) {
            steps.add(HTTPServer.removeHttpsListener(context, serverName, httpsListener));
        } else if (HTTPServer.isLegacySecurityRealmSupported(context)) {
            steps.add(HTTPServer.writeServerAttribute(serverName, httpsListener, "ssl-context", null));
            steps.add(HTTPServer.writeServerAttribute(serverName, httpsListener, "security-realm", DefaultResourceNames.getDefaultApplicationLegacyRealm()));
        } else if (ElytronUtil.hasServerSSLContext(context, defaultAppSSLContext)) {
            steps.add(HTTPServer.writeServerAttribute(serverName, httpsListener, "ssl-context", defaultAppSSLContext));
        } else {
            throw new OperationFormatException("No " + defaultAppSSLContext + " default SSL Context to use.");
        }
        return serverName;
    }

    public static String getSSLContextName(String serverName, String httpsListener, CommandContext ctx) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-attribute");
        builder.addNode("subsystem", "undertow");
        builder.addNode("server", serverName);
        builder.addNode("https-listener", httpsListener);
        builder.addProperty("name", "ssl-context");
        ModelNode request = builder.buildRequest();
        ModelNode outcome = ctx.getModelControllerClient().execute(request);
        if (Util.isSuccess(outcome) && outcome.hasDefined("result")) {
            return outcome.get("result").asString();
        }
        return null;
    }

    public static boolean isUnderowSupported(CommandContext commandContext) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "undertow");
        ModelNode response = commandContext.getModelControllerClient().execute(builder.buildRequest());
        return Util.isSuccess(response);
    }

    public static boolean isReferencedSecurityDomainSupported(CommandContext commandContext) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource-description");
        builder.addNode("subsystem", "undertow");
        builder.addNode("application-security-domain", "?");
        ModelNode response = commandContext.getModelControllerClient().execute(builder.buildRequest());
        if (Util.isSuccess(response) && response.get("result").hasDefined("attributes")) {
            return response.get("result").get("attributes").hasDefined("security-domain");
        }
        return false;
    }

    public static boolean isLegacySecurityRealmSupported(CommandContext commandContext) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource-description");
        builder.addNode("core-service", "management");
        builder.addNode("security-realm", "?");
        ModelNode response = commandContext.getModelControllerClient().execute(builder.buildRequest());
        return Util.isSuccess(response);
    }

    public static boolean hasHttpsListener(CommandContext commandContext, String serverName, String httpsListener) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "undertow");
        builder.addNode("server", serverName);
        builder.addNode("https-listener", httpsListener);
        ModelNode response = commandContext.getModelControllerClient().execute(builder.buildRequest());
        return Util.isSuccess(response);
    }

    public static ModelNode addHttpsListener(String serverName, String httpsListenerName, String socketBindingName, String sslContext) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "undertow");
        builder.addNode("server", serverName);
        builder.addNode("https-listener", httpsListenerName);
        builder.addProperty("socket-binding", socketBindingName);
        builder.addProperty("ssl-context", sslContext);
        return builder.buildRequest();
    }

    public static ModelNode removeHttpsListener(CommandContext commandContext, String serverName, String httpsListener) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("remove");
        builder.addNode("subsystem", "undertow");
        builder.addNode("server", serverName);
        builder.addNode("https-listener", httpsListener);
        return builder.buildRequest();
    }

    public static ApplicationSecurityDomain getSecurityDomain(CommandContext ctx, String name) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "undertow");
        builder.addNode("application-security-domain", name);
        ModelNode mn = ctx.getModelControllerClient().execute(builder.buildRequest());
        ApplicationSecurityDomain dom = null;
        if (Util.isSuccess(mn)) {
            ModelNode result = mn.get("result");
            String factory = null;
            String secDomain = null;
            if (result.hasDefined("http-authentication-factory")) {
                factory = result.get("http-authentication-factory").asString();
            }
            if (result.hasDefined("security-domain")) {
                secDomain = result.get("security-domain").asString();
            }
            dom = new ApplicationSecurityDomain(name, factory, secDomain);
        }
        return dom;
    }

    public static void writeReferencedSecurityDomain(AuthSecurityBuilder authBuilder, String securityDomain, CommandContext ctx) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("write-attribute");
        builder.addNode("subsystem", "undertow");
        builder.addNode("application-security-domain", securityDomain);
        builder.addProperty("name", "security-domain");
        builder.addProperty("value", authBuilder.getReferencedSecurityDomain());
        authBuilder.getSteps().add(builder.buildRequest());
    }

    public static boolean hasAuthFactory(CommandContext ctx, String securityDomain) throws OperationFormatException, IOException {
        ApplicationSecurityDomain dom = HTTPServer.getSecurityDomain(ctx, securityDomain);
        if (dom != null) {
            return dom.getFactory() != null;
        }
        return false;
    }

    public static void enableHTTPAuthentication(AuthSecurityBuilder builder, String securityDomain, CommandContext ctx) throws Exception {
        DefaultOperationRequestBuilder reqBuilder = new DefaultOperationRequestBuilder();
        reqBuilder.setOperationName("add");
        reqBuilder.addNode("subsystem", "undertow");
        reqBuilder.addNode("application-security-domain", securityDomain);
        if (builder.getReferencedSecurityDomain() == null) {
            reqBuilder.addProperty("http-authentication-factory", builder.getAuthFactory().getName());
        } else {
            reqBuilder.addProperty("security-domain", builder.getReferencedSecurityDomain());
        }
        builder.getSteps().add(reqBuilder.buildRequest());
    }

    public static ModelNode disableHTTPAuthentication(String securityDomain, CommandContext ctx) throws Exception {
        DefaultOperationRequestBuilder reqBuilder = new DefaultOperationRequestBuilder();
        reqBuilder.setOperationName("remove");
        reqBuilder.addNode("subsystem", "undertow");
        reqBuilder.addNode("application-security-domain", securityDomain);
        return reqBuilder.buildRequest();
    }

    public static String getSecurityDomainFactoryName(String securityDomain, CommandContext ctx) throws IOException, OperationFormatException {
        ApplicationSecurityDomain dom = HTTPServer.getSecurityDomain(ctx, securityDomain);
        if (dom != null) {
            return dom.getFactory();
        }
        return null;
    }

    public static String getReferencedSecurityDomainName(String securityDomain, CommandContext ctx) throws IOException, OperationFormatException {
        ApplicationSecurityDomain dom = HTTPServer.getSecurityDomain(ctx, securityDomain);
        if (dom != null) {
            return dom.getSecurityDomain();
        }
        return null;
    }
}

