/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.tool;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.tool.ContentVerificationPolicy;
import org.jboss.as.patching.tool.PatchTool;

class ContentPolicyBuilderImpl
implements PatchTool.ContentPolicyBuilder {
    boolean overrideAll;
    boolean ignoreModulesChanges;
    final List<String> override = new ArrayList<String>();
    final List<String> preserve = new ArrayList<String>();

    ContentPolicyBuilderImpl() {
    }

    @Override
    public ContentVerificationPolicy createPolicy() {
        return new ContentVerificationPolicy(){

            @Override
            public boolean ignoreContentValidation(ContentItem item) {
                ContentType type = item.getContentType();
                if (type == ContentType.MODULE || type == ContentType.BUNDLE) {
                    return ContentPolicyBuilderImpl.this.ignoreModulesChanges || ContentPolicyBuilderImpl.this.overrideAll;
                }
                MiscContentItem misc = (MiscContentItem)item;
                String path = misc.getRelativePath();
                if (ContentPolicyBuilderImpl.this.override.contains(path)) {
                    return true;
                }
                if (ContentPolicyBuilderImpl.this.preserve.contains(path)) {
                    return true;
                }
                return ContentPolicyBuilderImpl.this.overrideAll;
            }

            @Override
            public boolean preserveExisting(ContentItem item) {
                ContentType type = item.getContentType();
                if (type == ContentType.MISC) {
                    MiscContentItem misc = (MiscContentItem)item;
                    String path = misc.getRelativePath();
                    return ContentPolicyBuilderImpl.this.preserve.contains(path);
                }
                return false;
            }
        };
    }

    @Override
    public PatchTool.ContentPolicyBuilder ignoreModuleChanges() {
        this.ignoreModulesChanges = true;
        return this;
    }

    @Override
    public PatchTool.ContentPolicyBuilder overrideItem(MiscContentItem item) {
        return this.overrideItem(item.getRelativePath());
    }

    @Override
    public PatchTool.ContentPolicyBuilder overrideItem(String path) {
        this.override.add(path);
        return this;
    }

    @Override
    public PatchTool.ContentPolicyBuilder preserveItem(MiscContentItem item) {
        return this.preserveItem(item.getRelativePath());
    }

    @Override
    public PatchTool.ContentPolicyBuilder preserveItem(String path) {
        this.preserve.add(path);
        return this;
    }

    @Override
    public PatchTool.ContentPolicyBuilder overrideAll() {
        this.overrideAll = true;
        return this;
    }
}

