/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.locks;

import com.ibm.asyncutil.locks.AsyncLock;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class FairAsyncLock
implements AsyncLock {
    private static final Node NULL_PREDECESSOR = new Node();
    private static final AtomicReferenceFieldUpdater<FairAsyncLock, Node> UPDATER = AtomicReferenceFieldUpdater.newUpdater(FairAsyncLock.class, Node.class, "head");
    private volatile Node head;

    public FairAsyncLock() {
        Node n = new Node();
        n.prev = NULL_PREDECESSOR;
        n.complete(n);
        this.head = n;
    }

    @Override
    public CompletionStage<AsyncLock.LockToken> acquireLock() {
        Node oldHead;
        Node newHead = new Node();
        newHead.prev = oldHead = UPDATER.getAndSet(this, newHead);
        oldHead.next = newHead;
        return oldHead;
    }

    @Override
    public Optional<AsyncLock.LockToken> tryLock() {
        Node newHead;
        Node oldHead = this.head;
        if (oldHead.isDone() && UPDATER.compareAndSet(this, oldHead, newHead = new Node())) {
            newHead.prev = oldHead;
            oldHead.next = newHead;
            return Optional.of(oldHead);
        }
        return Optional.empty();
    }

    private static final class Node
    extends CompletableFuture<AsyncLock.LockToken>
    implements AsyncLock.LockToken {
        Node next;
        Node prev;
        private Thread releaseThread;

        private Node() {
        }

        @Override
        public void releaseLock() {
            if (this.next == null) {
                throw new IllegalStateException("released lock not in locked state");
            }
            this.releaseThread = Thread.currentThread();
            if (this.releaseThread.equals(this.prev.releaseThread)) {
                this.prev.next = this.next;
                this.next.prev = this.prev;
                this.next = null;
            } else {
                do {
                    Node n = this.next;
                    this.next = null;
                    n.complete(n);
                } while (this.next != null);
            }
            this.releaseThread = null;
            this.prev = null;
        }
    }
}

