/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.el.glassfish.lang;

import com.sun.el.lang.FunctionMapperImpl;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.SimpleObjectOutput;

public class FunctionMarshaller
implements ProtoStreamMarshaller<FunctionMapperImpl.Function> {
    private static final int PREFIX_INDEX = 1;
    private static final int LOCAL_NAME_INDEX = 2;
    private static final int DECLARING_CLASS_INDEX = 3;
    private static final int METHOD_NAME_INDEX = 4;
    private static final int PARAMETER_TYPE_INDEX = 5;

    public Class<? extends FunctionMapperImpl.Function> getJavaClass() {
        return FunctionMapperImpl.Function.class;
    }

    public FunctionMapperImpl.Function readFrom(ProtoStreamReader reader) throws IOException {
        String prefix = null;
        String localName = null;
        Class declaringClass = null;
        String methodName = null;
        LinkedList<Class> parameterTypes = new LinkedList<Class>();
        block9: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    prefix = reader.readString();
                    continue block9;
                }
                case 2: {
                    localName = reader.readString();
                    continue block9;
                }
                case 3: {
                    declaringClass = (Class)reader.readAny(Class.class);
                    continue block9;
                }
                case 4: {
                    methodName = reader.readString();
                    continue block9;
                }
                case 5: {
                    parameterTypes.add((Class)reader.readAny(Class.class));
                    continue block9;
                }
            }
            reader.skipField(tag);
        }
        try {
            Method method = declaringClass != null ? declaringClass.getDeclaredMethod(methodName, parameterTypes.toArray(new Class[0])) : null;
            return new FunctionMapperImpl.Function(prefix, localName, method);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public void writeTo(ProtoStreamWriter writer, FunctionMapperImpl.Function function) throws IOException {
        Method method;
        String localName;
        String[] strings = new String[4];
        function.writeExternal(new SimpleObjectOutput.Builder().with(strings).build());
        String prefix = strings[0];
        if (!prefix.isEmpty()) {
            writer.writeString(1, prefix);
        }
        if ((localName = strings[1]) != null) {
            writer.writeString(2, localName);
        }
        if ((method = function.getMethod()) != null) {
            writer.writeAny(3, method.getDeclaringClass());
            writer.writeString(4, method.getName());
            for (Class<?> parameterType : method.getParameterTypes()) {
                writer.writeAny(5, parameterType);
            }
        }
    }
}

