/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.modules.Module;

public class SimpleEnvEntryCdiResourceInjectionProcessor
implements DeploymentUnitProcessor {
    private static final Map<String, Class<?>> SIMPLE_ENTRY_TYPES;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPES;

    private static void store(Class<?> clazz, Map<String, Class<?>> map) {
        map.put(clazz.getName(), clazz);
    }

    public void deploy(DeploymentPhaseContext deploymentPhaseContext) throws DeploymentUnitProcessingException {
        Module module;
        EnvEntryCdiExtension extension;
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        Optional optional = support.getOptionalCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
        if (optional.isPresent() && ((WeldCapability)optional.get()).isPartOfWeldDeployment(deploymentUnit) && (extension = this.getEnvEntryCdiExtension(deploymentUnit, (ClassLoader)(module = (Module)deploymentUnit.getAttachment(Attachments.MODULE)).getClassLoader())) != null) {
            ((WeldCapability)optional.get()).registerExtensionInstance((Extension)extension, deploymentUnit);
            WeldLogger.DEPLOYMENT_LOGGER.debugf("Registered CDI Extension %s", (Object)extension);
        }
    }

    private EnvEntryCdiExtension getEnvEntryCdiExtension(DeploymentUnit deploymentUnit, ClassLoader classLoader) {
        EnvironmentEntriesMetaData envEntries;
        EnvEntryCdiExtension extension = null;
        DeploymentDescriptorEnvironment environment = (DeploymentDescriptorEnvironment)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.MODULE_DEPLOYMENT_DESCRIPTOR_ENVIRONMENT);
        EnvironmentEntriesMetaData environmentEntriesMetaData = envEntries = environment == null ? null : environment.getEnvironment().getEnvironmentEntries();
        if (envEntries != null) {
            HashMap<String, Map> entriesWithoutValues = new HashMap<String, Map>();
            HashMap<String, Map> envEntryInjections = new HashMap<String, Map>();
            for (EnvironmentEntryMetaData eemd : envEntries) {
                Set rimds;
                Set set = rimds = eemd.isDependencyIgnored() ? null : eemd.getInjectionTargets();
                if (rimds == null) continue;
                Class<?> entryType = null;
                if (eemd.getType() != null && (entryType = SimpleEnvEntryCdiResourceInjectionProcessor.getSimpleEntryType(eemd.getType(), classLoader)) == null) continue;
                for (ResourceInjectionTargetMetaData rimd : rimds) {
                    Map toPut;
                    String value = eemd.getValue();
                    String lookup = eemd.getLookupName();
                    if ((value == null || value.isEmpty()) && (lookup == null || lookup.isEmpty())) {
                        toPut = entriesWithoutValues.computeIfAbsent(rimd.getInjectionTargetClass(), k -> new HashMap());
                        WeldLogger.DEPLOYMENT_LOGGER.debugf("Adding %s/%s to injection disabled map", (Object)eemd.getEnvEntryName(), entryType);
                    } else {
                        toPut = envEntryInjections.computeIfAbsent(rimd.getInjectionTargetClass(), k -> new HashMap());
                        WeldLogger.DEPLOYMENT_LOGGER.debugf("Adding %s/%s to injection added map", (Object)eemd.getEnvEntryName(), entryType);
                    }
                    toPut.put(rimd.getInjectionTargetName(), new InjectionData(eemd, rimd, entryType));
                }
            }
            if (!entriesWithoutValues.isEmpty() || !envEntryInjections.isEmpty()) {
                extension = new EnvEntryCdiExtension(entriesWithoutValues.isEmpty() ? Collections.emptyMap() : entriesWithoutValues, envEntryInjections.isEmpty() ? Collections.emptyMap() : envEntryInjections);
            }
        }
        return extension;
    }

    private static Class<?> getSimpleEntryType(String type, ClassLoader classLoader) {
        assert (type != null);
        Class<?> result = SIMPLE_ENTRY_TYPES.get(type);
        if (result == null && !type.equals(Void.TYPE.getName())) {
            try {
                Class<?> clazz = Class.forName(type, false, classLoader);
                if (clazz.isEnum()) {
                    result = clazz;
                }
            }
            catch (ClassNotFoundException e) {
                throw WeldLogger.ROOT_LOGGER.cannotLoadClass(type, (Throwable)e);
            }
        }
        return result;
    }

    private static String methodNameAsField(Method method) {
        String result = null;
        String methodName = method.getName();
        if (methodName.startsWith("set") && methodName.length() > 3) {
            String withoutSet = methodName.substring(3);
            char initial = Character.toLowerCase(withoutSet.charAt(0));
            result = withoutSet.length() > 1 ? initial + withoutSet.substring(1) : String.valueOf(initial);
        }
        return result;
    }

    private static boolean isMatchingType(Class<?> memberType, Class<?> entryType) {
        assert (memberType != null);
        return entryType == null && (SIMPLE_ENTRY_TYPES.containsKey(memberType.getName()) || memberType.isEnum()) || entryType != null && (memberType.isAssignableFrom(entryType) || entryType.equals(PRIMITIVE_TYPES.get(memberType)));
    }

    private static boolean testNoValueAnnotation(Annotation a, InjectionData injectionData, Class<?> targetType) {
        return injectionData != null && a instanceof Resource && SimpleEnvEntryCdiResourceInjectionProcessor.testNoValueResource((Resource)a, injectionData, targetType);
    }

    private static boolean testNoValueResource(Resource resource, InjectionData injectionData, Class<?> targetType) {
        boolean result = injectionData != null && resource.lookup().isEmpty() && resource.mappedName().isEmpty() && SimpleEnvEntryCdiResourceInjectionProcessor.isMatchingType(targetType, injectionData.envType) && (resource.name().equals(injectionData.eemd.getEnvEntryName()) || resource.name().isEmpty() && injectionData.isEntryNameTargetName());
        WeldLogger.DEPLOYMENT_LOGGER.debugf("Disable injection into %s? %s", (Object)resource, (Object)result);
        return result;
    }

    static {
        HashMap<Class, Class> primitives = new HashMap<Class, Class>();
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Boolean.TYPE, Boolean.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Double.TYPE, Double.class);
        PRIMITIVE_TYPES = Collections.unmodifiableMap(primitives);
        HashMap types = new HashMap();
        SimpleEnvEntryCdiResourceInjectionProcessor.store(String.class, types);
        SimpleEnvEntryCdiResourceInjectionProcessor.store(Character.class, types);
        SimpleEnvEntryCdiResourceInjectionProcessor.store(Byte.class, types);
        SimpleEnvEntryCdiResourceInjectionProcessor.store(Short.class, types);
        SimpleEnvEntryCdiResourceInjectionProcessor.store(Integer.class, types);
        SimpleEnvEntryCdiResourceInjectionProcessor.store(Long.class, types);
        SimpleEnvEntryCdiResourceInjectionProcessor.store(Boolean.class, types);
        SimpleEnvEntryCdiResourceInjectionProcessor.store(Double.class, types);
        SimpleEnvEntryCdiResourceInjectionProcessor.store(Float.class, types);
        SimpleEnvEntryCdiResourceInjectionProcessor.store(Class.class, types);
        primitives.forEach((k, v) -> types.put(k.getName(), (Class<?>)v));
        SIMPLE_ENTRY_TYPES = Collections.unmodifiableMap(types);
    }

    private static class UnmappedResourceLiteral
    extends AnnotationLiteral<Resource>
    implements Resource {
        private static final long serialVersionUID = 1L;
        private final InjectionData injectionData;

        private UnmappedResourceLiteral(InjectionData injectionData) {
            this.injectionData = injectionData;
        }

        public String name() {
            String name = this.injectionData.eemd.getEnvEntryName();
            return name == null ? "" : name;
        }

        public String lookup() {
            String lookup = this.injectionData.eemd.getLookupName();
            return lookup == null ? "" : lookup;
        }

        public Class<?> type() {
            Class<?> type = this.injectionData.envType;
            return type == null ? Object.class : type;
        }

        public Resource.AuthenticationType authenticationType() {
            return Resource.AuthenticationType.CONTAINER;
        }

        public boolean shareable() {
            return true;
        }

        public String mappedName() {
            return "";
        }

        public String description() {
            return "";
        }
    }

    private static class EnvEntryCdiExtension
    implements Extension {
        private final Map<String, Map<String, InjectionData>> entriesWithoutValues;
        private final Map<String, Map<String, InjectionData>> envEntryInjections;

        private EnvEntryCdiExtension(Map<String, Map<String, InjectionData>> entriesWithoutValues, Map<String, Map<String, InjectionData>> envEntryInjections) {
            this.entriesWithoutValues = entriesWithoutValues;
            this.envEntryInjections = envEntryInjections;
        }

        public <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event) {
            this.processEntriesWithoutValues(event);
            this.processEnvEntryInjections(event);
        }

        private <X> void processEntriesWithoutValues(ProcessAnnotatedType<X> event) {
            AnnotatedType annotatedType = event.getAnnotatedType();
            String typeName = annotatedType.getBaseType().getTypeName();
            Map<String, InjectionData> membersWithoutValues = this.entriesWithoutValues.get(typeName);
            if (membersWithoutValues != null) {
                AnnotatedTypeConfigurator typeConfigurator = event.configureAnnotatedType();
                Set annotatedFields = typeConfigurator.fields();
                for (AnnotatedFieldConfigurator annotatedFieldCfg : annotatedFields) {
                    AnnotatedField annotatedField = annotatedFieldCfg.getAnnotated();
                    Field field = annotatedField.getJavaMember();
                    InjectionData injectionData = membersWithoutValues.get(field.getName());
                    annotatedFieldCfg.remove(a -> SimpleEnvEntryCdiResourceInjectionProcessor.testNoValueAnnotation(a, injectionData, field.getType()));
                }
                Set annotatedMethods = typeConfigurator.methods();
                for (AnnotatedMethodConfigurator annotatedMethodCfg : annotatedMethods) {
                    String asField;
                    AnnotatedMethod annotatedMethod = annotatedMethodCfg.getAnnotated();
                    Method method = annotatedMethod.getJavaMember();
                    Class[] params = method.getParameterTypes();
                    if (params.length != 1 || (asField = SimpleEnvEntryCdiResourceInjectionProcessor.methodNameAsField(method)) == null) continue;
                    InjectionData injectionData = membersWithoutValues.get(asField);
                    annotatedMethodCfg.remove(a -> SimpleEnvEntryCdiResourceInjectionProcessor.testNoValueAnnotation(a, injectionData, params[0]));
                }
            } else {
                WeldLogger.DEPLOYMENT_LOGGER.tracef("%s is not in the injection disabled map", (Object)typeName);
            }
        }

        private <X> void processEnvEntryInjections(ProcessAnnotatedType<X> event) {
            AnnotatedType annotatedType = event.getAnnotatedType();
            String typeName = annotatedType.getBaseType().getTypeName();
            Map<String, InjectionData> envEntryInjection = this.envEntryInjections.get(typeName);
            if (envEntryInjection != null) {
                AnnotatedTypeConfigurator typeConfigurator = event.configureAnnotatedType();
                Set annotatedFields = typeConfigurator.fields();
                for (AnnotatedFieldConfigurator annotatedFieldCfg : annotatedFields) {
                    AnnotatedField annotatedField = annotatedFieldCfg.getAnnotated();
                    if (!annotatedField.getAnnotations(Resource.class).isEmpty()) continue;
                    Field field = annotatedField.getJavaMember();
                    InjectionData injectionData = envEntryInjection.get(field.getName());
                    if (injectionData != null && SimpleEnvEntryCdiResourceInjectionProcessor.isMatchingType(field.getType(), injectionData.envType)) {
                        annotatedFieldCfg.add((Annotation)((Object)new UnmappedResourceLiteral(injectionData)));
                        WeldLogger.DEPLOYMENT_LOGGER.debugf("Added injection into %s", (Object)field);
                        continue;
                    }
                    if (injectionData == null || injectionData.envType == null) continue;
                    WeldLogger.DEPLOYMENT_LOGGER.debugf("Entry type %s cannot be assigned to %s", injectionData.envType, (Object)field);
                }
                Set annotatedMethods = typeConfigurator.methods();
                for (AnnotatedMethodConfigurator annotatedMethodCfg : annotatedMethods) {
                    String asField;
                    Method method;
                    Class<?>[] params;
                    AnnotatedMethod annotatedMethod = annotatedMethodCfg.getAnnotated();
                    if (!annotatedMethod.getAnnotations(Resource.class).isEmpty() || (params = (method = annotatedMethod.getJavaMember()).getParameterTypes()).length != 1 || (asField = SimpleEnvEntryCdiResourceInjectionProcessor.methodNameAsField(method)) == null) continue;
                    InjectionData injectionData = envEntryInjection.get(asField);
                    if (injectionData != null && SimpleEnvEntryCdiResourceInjectionProcessor.isMatchingType(params[0], injectionData.envType)) {
                        annotatedMethodCfg.add((Annotation)((Object)new UnmappedResourceLiteral(injectionData)));
                        WeldLogger.DEPLOYMENT_LOGGER.debugf("Added injection into %s", (Object)method);
                        continue;
                    }
                    if (injectionData == null || injectionData.envType == null) continue;
                    WeldLogger.DEPLOYMENT_LOGGER.debugf("Entry type %s cannot be passed to %s", injectionData.envType, (Object)method);
                }
            } else {
                WeldLogger.DEPLOYMENT_LOGGER.tracef("%s is not in the env-entry injection map", (Object)typeName);
            }
        }
    }

    private static class InjectionData {
        private final EnvironmentEntryMetaData eemd;
        private final ResourceInjectionTargetMetaData rimd;
        private final Class<?> envType;

        private InjectionData(EnvironmentEntryMetaData eemd, ResourceInjectionTargetMetaData rimd, Class<?> envType) {
            this.eemd = eemd;
            this.rimd = rimd;
            this.envType = envType;
        }

        private boolean isEntryNameTargetName() {
            String concat = this.rimd.getInjectionTargetClass() + "/" + this.rimd.getInjectionTargetName();
            return concat.equals(this.eemd.getEnvEntryName());
        }
    }
}

