/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.concurrent;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.wildfly.clustering.ee.concurrent.ServiceExecutor;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public class StampedLockServiceExecutor
implements ServiceExecutor {
    private final StampedLock lock = new StampedLock();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable executeTask) {
        long stamp = this.lock.tryReadLock();
        if (stamp != 0L) {
            try {
                executeTask.run();
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Exception> void execute(ExceptionRunnable<E> executeTask) throws E {
        long stamp = this.lock.tryReadLock();
        if (stamp != 0L) {
            try {
                executeTask.run();
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> Optional<R> execute(Supplier<R> executeTask) {
        long stamp = this.lock.tryReadLock();
        if (stamp != 0L) {
            try {
                Optional<R> optional = Optional.of(executeTask.get());
                return optional;
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, E extends Exception> Optional<R> execute(ExceptionSupplier<R, E> executeTask) throws E {
        long stamp = this.lock.tryReadLock();
        if (stamp != 0L) {
            try {
                Optional<Object> optional = Optional.of(executeTask.get());
                return optional;
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
        return Optional.empty();
    }

    public void close(Runnable closeTask) {
        if (this.closed.compareAndSet(false, true)) {
            this.lock.writeLock();
            closeTask.run();
        }
    }
}

