/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class SessionAddMetaDataMessage
extends PacketImpl {
    private String key;
    private String data;

    public SessionAddMetaDataMessage() {
        super((byte)104);
    }

    public SessionAddMetaDataMessage(String k, String d) {
        this();
        this.key = k;
        this.data = d;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeString(this.key);
        buffer.writeString(this.data);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.key = buffer.readString();
        this.data = buffer.readString();
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    public String getKey() {
        return this.key;
    }

    public String getData() {
        return this.data;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionAddMetaDataMessage)) {
            return false;
        }
        SessionAddMetaDataMessage other = (SessionAddMetaDataMessage)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }
}

