/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging.events.impl;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.events.EventLog;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;
import org.infinispan.util.logging.events.EventLogger;
import org.infinispan.util.logging.events.Messages;

public class DecoratedEventLogger
implements EventLogger {
    private static final String LOCAL_SCOPE = "local";
    private final EventLogger delegate;
    protected String detail;
    protected String context;
    protected String scope;
    protected String who;

    protected DecoratedEventLogger(EventLogger delegate) {
        this.delegate = delegate;
    }

    @Override
    public void log(EventLogLevel level, EventLogCategory category, String message) {
        StringBuilder sb = new StringBuilder();
        this.addLogsToBuilder(sb);
        sb.append(' ');
        sb.append(message);
        this.delegate.log(level, category, sb.toString());
    }

    protected void addLogsToBuilder(StringBuilder sb) {
        if (this.context != null) {
            sb.append(Messages.MESSAGES.eventLogContext(this.context));
        }
        if (this.scope != null) {
            sb.append(Messages.MESSAGES.eventLogContext(this.scope));
        }
        if (this.who != null) {
            sb.append(Messages.MESSAGES.eventLogContext(this.who));
        }
    }

    @Override
    public EventLogger who(String who) {
        this.who = who;
        return this;
    }

    @Override
    public EventLogger scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public EventLogger scope(Address scope) {
        this.scope = scope != null ? scope.toString() : LOCAL_SCOPE;
        return this;
    }

    @Override
    public EventLogger context(String context) {
        this.context = context;
        return this;
    }

    @Override
    public EventLogger detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Override
    public List<EventLog> getEvents(Instant start, int count, Optional<EventLogCategory> category, Optional<EventLogLevel> level) {
        return this.delegate.getEvents(start, count, category, level);
    }
}

