/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import org.jboss.remoting3._private.Messages;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionProvider;
import org.jboss.remoting3.remote.ServerConnectionOpenListener;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.ExternalConnectionProvider;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FailedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.channels.SslChannel;
import org.xnio.http.HandshakeChecker;
import org.xnio.http.HttpUpgrade;
import org.xnio.ssl.SslConnection;

final class HttpUpgradeConnectionProvider
extends RemoteConnectionProvider {
    public static final String MAGIC_NUMBER = "CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD";
    public static final String SEC_JBOSS_REMOTING_KEY = "Sec-JbossRemoting-Key";
    public static final String SEC_JBOSS_REMOTING_ACCEPT = "sec-jbossremoting-accept";
    public static final String UPGRADE = "Upgrade";
    private final ProviderInterface providerInterface = new ProviderInterface();

    HttpUpgradeConnectionProvider(OptionMap optionMap, ConnectionProviderContext connectionProviderContext, String protocolName) throws IOException {
        super(optionMap, connectionProviderContext, protocolName);
    }

    @Override
    protected IoFuture<StreamConnection> createConnection(URI uri, InetSocketAddress bindAddress, InetSocketAddress destination, OptionMap connectOptions, ChannelListener<StreamConnection> openListener) {
        URI newUri;
        try {
            newUri = new URI("http", "", uri.getHost(), uri.getPort(), "/", "", "");
        }
        catch (URISyntaxException e) {
            return new FailedIoFuture(new IOException(e));
        }
        FutureResult returnedFuture = new FutureResult(this.getExecutor());
        UpgradeListener<StreamConnection> upgradeListener = new UpgradeListener<StreamConnection>(StreamConnection.class, newUri, openListener, returnedFuture);
        IoFuture<StreamConnection> rawFuture = super.createConnection(uri, bindAddress, destination, connectOptions, upgradeListener);
        rawFuture.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<StreamConnection, FutureResult<StreamConnection>>(){

            public void handleCancelled(FutureResult<StreamConnection> attachment) {
                attachment.setCancelled();
            }

            public void handleFailed(IOException exception, FutureResult<StreamConnection> attachment) {
                attachment.setException(exception);
            }
        }, (Object)returnedFuture);
        return returnedFuture.getIoFuture();
    }

    @Override
    protected IoFuture<SslConnection> createSslConnection(URI uri, InetSocketAddress bindAddress, InetSocketAddress destination, OptionMap options, AuthenticationConfiguration configuration, SSLContext sslContext, ChannelListener<StreamConnection> openListener) {
        URI newUri;
        try {
            newUri = new URI("https", "", uri.getHost(), uri.getPort(), "/", "", "");
        }
        catch (URISyntaxException e) {
            return new FailedIoFuture(new IOException(e));
        }
        FutureResult returnedFuture = new FutureResult(this.getExecutor());
        OptionMap modifiedOptions = OptionMap.builder().addAll(options).set(Options.SSL_STARTTLS, false).getMap();
        UpgradeListener<SslConnection> upgradeListener = new UpgradeListener<SslConnection>(SslConnection.class, newUri, openListener, returnedFuture);
        IoFuture<SslConnection> rawFuture = super.createSslConnection(uri, bindAddress, destination, modifiedOptions, configuration, sslContext, upgradeListener);
        rawFuture.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<StreamConnection, FutureResult<SslConnection>>(){

            public void handleCancelled(FutureResult<SslConnection> attachment) {
                attachment.setCancelled();
            }

            public void handleFailed(IOException exception, FutureResult<SslConnection> attachment) {
                attachment.setException(exception);
            }
        }, (Object)returnedFuture);
        return returnedFuture.getIoFuture();
    }

    @Override
    public ProviderInterface getProviderInterface() {
        return this.providerInterface;
    }

    protected static String createSecKey() {
        SecureRandom random = new SecureRandom();
        byte[] data = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int val = random.nextInt();
            data[i * 4] = (byte)val;
            data[i * 4 + 1] = (byte)(val >> 8 & 0xFF);
            data[i * 4 + 2] = (byte)(val >> 16 & 0xFF);
            data[i * 4 + 3] = (byte)(val >> 24 & 0xFF);
        }
        return Base64.getEncoder().encodeToString(data);
    }

    protected static String createExpectedResponse(String secKey) throws IOException {
        try {
            String concat = secKey + MAGIC_NUMBER;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(concat.getBytes("UTF-8"));
            byte[] bytes = digest.digest();
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private final class ConnectionAdaptorImpl
    implements Consumer<StreamConnection> {
        private final OptionMap optionMap;
        private final SaslAuthenticationFactory saslAuthenticationFactory;

        ConnectionAdaptorImpl(OptionMap optionMap, SaslAuthenticationFactory saslAuthenticationFactory) {
            this.optionMap = optionMap;
            this.saslAuthenticationFactory = saslAuthenticationFactory;
        }

        @Override
        public void accept(StreamConnection channel) {
            if (channel.getWorker() != HttpUpgradeConnectionProvider.this.getXnioWorker()) {
                throw Messages.conn.invalidWorker();
            }
            try {
                channel.setOption(Options.TCP_NODELAY, (Object)Boolean.TRUE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            SslConnection sslChannel = channel instanceof SslConnection ? (SslConnection)channel : null;
            RemoteConnection connection = new RemoteConnection(channel, (SslChannel)sslChannel, this.optionMap, HttpUpgradeConnectionProvider.this);
            ServerConnectionOpenListener openListener = new ServerConnectionOpenListener(connection, HttpUpgradeConnectionProvider.this.getConnectionProviderContext(), this.saslAuthenticationFactory, this.optionMap);
            channel.getSinkChannel().setWriteListener((ChannelListener)connection.getWriteListener());
            Messages.conn.tracef("Accepted connection from %s to %s", channel.getPeerAddress(), channel.getLocalAddress());
            openListener.handleEvent(channel.getSourceChannel());
        }
    }

    final class ProviderInterface
    implements ExternalConnectionProvider {
        ProviderInterface() {
        }

        public ConnectionAdaptorImpl createConnectionAdaptor(OptionMap optionMap, SaslAuthenticationFactory saslAuthenticationFactory) throws IOException {
            Assert.checkNotNullParam((String)"optionMap", (Object)optionMap);
            Assert.checkNotNullParam((String)"saslAuthenticationFactory", (Object)saslAuthenticationFactory);
            return new ConnectionAdaptorImpl(optionMap, saslAuthenticationFactory);
        }
    }

    private static class RemotingHandshakeChecker
    implements HandshakeChecker {
        private final String key;

        private RemotingHandshakeChecker(String key) {
            this.key = key;
        }

        public void checkHandshake(Map<String, String> headers) throws IOException {
            if (!headers.containsKey(HttpUpgradeConnectionProvider.SEC_JBOSS_REMOTING_ACCEPT)) {
                throw new IOException("No sec-jbossremoting-accept header in response");
            }
            String expectedResponse = HttpUpgradeConnectionProvider.createExpectedResponse(this.key);
            String response = headers.get(HttpUpgradeConnectionProvider.SEC_JBOSS_REMOTING_ACCEPT);
            if (!response.equals(expectedResponse)) {
                throw new IOException("sec-jbossremoting-accept value of " + response + " did not match expected " + expectedResponse);
            }
        }
    }

    private static class UpgradeListener<T extends StreamConnection>
    implements ChannelListener<StreamConnection> {
        private final Class<T> type;
        private final URI uri;
        private final ChannelListener<StreamConnection> openListener;
        private final FutureResult<T> futureResult;

        UpgradeListener(Class<T> type, URI uri, ChannelListener<StreamConnection> openListener, FutureResult<T> futureResult) {
            this.type = type;
            this.uri = uri;
            this.openListener = openListener;
            this.futureResult = futureResult;
        }

        public void handleEvent(final StreamConnection channel) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(HttpUpgradeConnectionProvider.UPGRADE, "jboss-remoting");
            String secKey = HttpUpgradeConnectionProvider.createSecKey();
            headers.put(HttpUpgradeConnectionProvider.SEC_JBOSS_REMOTING_KEY, secKey);
            IoFuture upgradeFuture = HttpUpgrade.performUpgrade((StreamConnection)((StreamConnection)this.type.cast(channel)), (URI)this.uri, headers, upgradeChannel -> ChannelListeners.invokeChannelListener((Channel)upgradeChannel, this.openListener), (HandshakeChecker)new RemotingHandshakeChecker(secKey));
            this.futureResult.addCancelHandler(new Cancellable(){

                public Cancellable cancel() {
                    if (channel.isOpen()) {
                        IoUtils.safeClose((Closeable)channel);
                    }
                    return this;
                }
            });
            upgradeFuture.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<T, FutureResult<T>>(){

                public void handleCancelled(FutureResult<T> attachment) {
                    attachment.setCancelled();
                }

                public void handleFailed(IOException exception, FutureResult<T> attachment) {
                    attachment.setException(exception);
                }

                public void handleDone(T data, FutureResult<T> attachment) {
                    attachment.setResult(data);
                }
            }, this.futureResult);
        }
    }
}

