/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.webservices;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.wsf.spi.Loggers;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public class WebserviceDescriptionMetaData {
    private volatile WebservicesMetaData webservices;
    private final String webserviceDescriptionName;
    private final String wsdlFile;
    private final String jaxrpcMappingFile;
    private final List<PortComponentMetaData> portComponents;

    public WebserviceDescriptionMetaData(String webserviceDescriptionName, String wsdlFile, String jaxrpcMappingFile, PortComponentMetaData ... portComponents) {
        this(webserviceDescriptionName, wsdlFile, jaxrpcMappingFile, portComponents != null ? Arrays.asList(portComponents) : null);
    }

    public WebserviceDescriptionMetaData(String webserviceDescriptionName, String wsdlFile, String jaxrpcMappingFile, List<PortComponentMetaData> portComponents) {
        this.webserviceDescriptionName = webserviceDescriptionName;
        this.wsdlFile = wsdlFile;
        this.jaxrpcMappingFile = jaxrpcMappingFile;
        if (portComponents != null && !portComponents.isEmpty()) {
            this.portComponents = Collections.unmodifiableList(portComponents);
            for (PortComponentMetaData pcm : portComponents) {
                pcm.setWebserviceDescription(this);
            }
        } else {
            this.portComponents = Collections.emptyList();
        }
    }

    public WebservicesMetaData getWebservices() {
        return this.webservices;
    }

    protected void setWebservices(WebservicesMetaData webservices) {
        this.webservices = webservices;
    }

    public PortComponentMetaData[] getPortComponents() {
        PortComponentMetaData[] array = new PortComponentMetaData[this.portComponents.size()];
        this.portComponents.toArray(array);
        return array;
    }

    public Collection<QName> getPortComponentQNames() {
        HashMap<String, QName> map = new HashMap<String, QName>();
        for (PortComponentMetaData pcm : this.portComponents) {
            QName qname = pcm.getWsdlPort();
            map.put(qname.getPrefix(), qname);
        }
        return map.values();
    }

    public PortComponentMetaData getPortComponentByWsdlPort(String name) {
        ArrayList<String> pcNames = new ArrayList<String>();
        for (PortComponentMetaData pc : this.portComponents) {
            String wsdlPortName = pc.getWsdlPort().getLocalPart();
            if (wsdlPortName.equals(name)) {
                return pc;
            }
            pcNames.add(wsdlPortName);
        }
        Loggers.METADATA_LOGGER.cannotGetPortComponentName(name, pcNames);
        return null;
    }

    public PortComponentMetaData getPortComponentByEjbLinkName(String ejbName) {
        for (PortComponentMetaData pc : this.portComponents) {
            if (!ejbName.equals(pc.getEjbLink())) continue;
            return pc;
        }
        return null;
    }

    public String getWebserviceDescriptionName() {
        return this.webserviceDescriptionName;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public String getJaxrpcMappingFile() {
        return this.jaxrpcMappingFile;
    }

    public String serialize() {
        StringBuilder buffer = new StringBuilder("<webservice-description>");
        buffer.append("<webservice-description-name>").append(this.webserviceDescriptionName).append("</webservice-description-name>");
        buffer.append("<wsdl-file>").append(this.wsdlFile).append("</wsdl-file>");
        buffer.append("<jaxrpc-mapping-file>").append(this.jaxrpcMappingFile).append("</jaxrpc-mapping-file>");
        for (PortComponentMetaData pm : this.portComponents) {
            buffer.append(pm.serialize());
        }
        buffer.append("</webservice-description>");
        return buffer.toString();
    }
}

