/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.sasl.scram;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.scram.ScramClientFunctionality;
import org.apache.activemq.artemis.protocol.amqp.sasl.scram.ScramClientFunctionalityImpl;
import org.apache.activemq.artemis.spi.core.security.scram.SCRAM;
import org.apache.activemq.artemis.spi.core.security.scram.ScramException;
import org.apache.qpid.proton.codec.DecodeException;

public class SCRAMClientSASL
implements ClientSASL {
    private final SCRAM scramType;
    private final ScramClientFunctionalityImpl client;
    private final String username;
    private final String password;

    public SCRAMClientSASL(SCRAM scram, String username, String password) {
        this(scram, username, password, UUID.randomUUID().toString());
    }

    protected SCRAMClientSASL(SCRAM scram, String username, String password, String nonce) {
        Objects.requireNonNull(scram);
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        this.username = username;
        this.password = password;
        this.scramType = scram;
        this.client = new ScramClientFunctionalityImpl(scram.getDigest(), scram.getHmac(), nonce);
    }

    @Override
    public String getName() {
        return this.scramType.getName();
    }

    @Override
    public byte[] getInitialResponse() {
        try {
            String firstMessage = this.client.prepareFirstMessage(this.username);
            return firstMessage.getBytes(StandardCharsets.US_ASCII);
        }
        catch (ScramException e) {
            throw new DecodeException("prepareFirstMessage failed", (Throwable)e);
        }
    }

    @Override
    public byte[] getResponse(byte[] challenge) {
        String msg = new String(challenge, StandardCharsets.US_ASCII);
        if (this.client.getState() == ScramClientFunctionality.State.FIRST_PREPARED) {
            try {
                String finalMessage = this.client.prepareFinalMessage(this.password, msg);
                return finalMessage.getBytes(StandardCharsets.US_ASCII);
            }
            catch (ScramException e) {
                throw new DecodeException("prepareFinalMessage failed", (Throwable)e);
            }
        }
        if (this.client.getState() == ScramClientFunctionality.State.FINAL_PREPARED) {
            try {
                this.client.checkServerFinalMessage(msg);
            }
            catch (ScramException e) {
                throw new DecodeException("checkServerFinalMessage failed", (Throwable)e);
            }
        }
        return new byte[0];
    }

    public static boolean isApplicable(String username, String password) {
        return username != null && username.length() > 0 && password != null && password.length() > 0;
    }
}

