/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.el.glassfish;

import com.sun.el.MethodExpressionLiteral;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.security.manager.WildFlySecurityManager;

public class MethodExpressionLiteralMarshaller
implements ProtoStreamMarshaller<MethodExpressionLiteral> {
    private static final int EXPRESSION_INDEX = 1;
    private static final int EXPECTED_TYPE_INDEX = 2;
    private static final int PARAMETER_TYPE_INDEX = 3;
    private static final Field EXPECTED_TYPE_FIELD = MethodExpressionLiteralMarshaller.getField(Class.class);
    private static final Field PARAMETER_TYPES_FIELD = MethodExpressionLiteralMarshaller.getField(Class[].class);

    private static Field getField(final Class<?> targetType) {
        return (Field)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                for (Field field : MethodExpressionLiteral.class.getDeclaredFields()) {
                    if (field.getType() != targetType) continue;
                    field.setAccessible(true);
                    return field;
                }
                throw new IllegalStateException();
            }
        });
    }

    public Class<? extends MethodExpressionLiteral> getJavaClass() {
        return MethodExpressionLiteral.class;
    }

    public MethodExpressionLiteral readFrom(ProtoStreamReader reader) throws IOException {
        String expression = null;
        Class expectedType = null;
        LinkedList<Class> parameterTypes = new LinkedList<Class>();
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    expression = reader.readString();
                    continue block5;
                }
                case 2: {
                    expectedType = (Class)reader.readAny(Class.class);
                    continue block5;
                }
                case 3: {
                    parameterTypes.add((Class)reader.readAny(Class.class));
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        return new MethodExpressionLiteral(expression, expectedType, parameterTypes.toArray(new Class[0]));
    }

    public void writeTo(ProtoStreamWriter writer, MethodExpressionLiteral value) throws IOException {
        Class[] parameterTypes;
        Class expectedType;
        String expression = value.getExpressionString();
        if (expression != null) {
            writer.writeString(1, expression);
        }
        if ((expectedType = MethodExpressionLiteralMarshaller.getValue(value, EXPECTED_TYPE_FIELD, Class.class)) != null) {
            writer.writeAny(2, (Object)expectedType);
        }
        if ((parameterTypes = MethodExpressionLiteralMarshaller.getValue(value, PARAMETER_TYPES_FIELD, Class[].class)).length > 0) {
            for (Class parameterType : parameterTypes) {
                writer.writeAny(3, (Object)parameterType);
            }
        }
    }

    private static <T> T getValue(final MethodExpressionLiteral value, final Field field, final Class<T> targetClass) {
        return (T)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    return targetClass.cast(field.get(value));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

