/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import org.hibernate.search.exception.AssertionFailure;

public final class DocumentFieldPath {
    private final String prefix;
    private final String relativeName;
    private final String absoluteName;

    public DocumentFieldPath(String prefix, String relativeName) {
        if (prefix == null) {
            throw new AssertionFailure("prefix must not be null");
        }
        this.prefix = prefix;
        if (relativeName == null) {
            throw new AssertionFailure("relativeName must not be null");
        }
        this.relativeName = relativeName;
        this.absoluteName = prefix + relativeName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getRelativeName() {
        return this.relativeName;
    }

    public String getAbsoluteName() {
        return this.absoluteName;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            DocumentFieldPath other = (DocumentFieldPath)obj;
            return this.absoluteName.equals(other.absoluteName);
        }
        return false;
    }

    public int hashCode() {
        return this.getAbsoluteName().hashCode();
    }

    public String toString() {
        return this.getAbsoluteName();
    }
}

