/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingResourceDefinition;
import org.jboss.as.logging.filters.FilterResourceDefinition;
import org.jboss.as.logging.formatters.CustomFormatterResourceDefinition;
import org.jboss.as.logging.formatters.PatternFormatterResourceDefinition;
import org.jboss.as.logging.handlers.AbstractHandlerDefinition;
import org.jboss.as.logging.handlers.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.handlers.ConsoleHandlerResourceDefinition;
import org.jboss.as.logging.handlers.PeriodicHandlerResourceDefinition;
import org.jboss.as.logging.handlers.SizeRotatingHandlerResourceDefinition;
import org.jboss.as.logging.handlers.SocketHandlerResourceDefinition;
import org.jboss.as.logging.handlers.SyslogHandlerResourceDefinition;
import org.jboss.as.logging.loggers.LoggerAttributes;

enum Element {
    UNKNOWN((String)null),
    ACCEPT((AttributeDefinition)CommonAttributes.ACCEPT),
    ADD_LOGGING_API_DEPENDENCIES((AttributeDefinition)LoggingResourceDefinition.ADD_LOGGING_API_DEPENDENCIES),
    ALL((AttributeDefinition)CommonAttributes.ALL),
    ANY((AttributeDefinition)CommonAttributes.ANY),
    APP_NAME((AttributeDefinition)SyslogHandlerResourceDefinition.APP_NAME),
    APPEND((AttributeDefinition)CommonAttributes.APPEND),
    ASYNC_HANDLER("async-handler"),
    CHANGE_LEVEL((AttributeDefinition)CommonAttributes.CHANGE_LEVEL),
    CONSOLE_HANDLER("console-handler"),
    CONSTRUCTOR_PROPERTIES((AttributeDefinition)FilterResourceDefinition.CONSTRUCTOR_PROPERTIES),
    CUSTOM_FORMATTER((AttributeDefinition)CustomFormatterResourceDefinition.CUSTOM_FORMATTER),
    CUSTOM_HANDLER("custom-handler"),
    DENY((AttributeDefinition)CommonAttributes.DENY),
    ENCODING((AttributeDefinition)CommonAttributes.ENCODING),
    FACILITY((AttributeDefinition)SyslogHandlerResourceDefinition.FACILITY),
    FILE((AttributeDefinition)CommonAttributes.FILE),
    FILE_HANDLER("file-handler"),
    FILTER((AttributeDefinition)CommonAttributes.FILTER),
    FILTER_SPEC("filter-spec"),
    FORMATTER((AttributeDefinition)AbstractHandlerDefinition.FORMATTER),
    HANDLERS((AttributeDefinition)LoggerAttributes.HANDLERS),
    HOSTNAME((AttributeDefinition)SyslogHandlerResourceDefinition.HOSTNAME),
    JSON_FORMATTER("json-formatter"),
    LEVEL((AttributeDefinition)CommonAttributes.LEVEL),
    LEVEL_RANGE((AttributeDefinition)CommonAttributes.LEVEL_RANGE_LEGACY),
    LOGGER("logger"),
    LOGGING_PROFILE("logging-profile"),
    LOGGING_PROFILES("logging-profiles"),
    MATCH((AttributeDefinition)CommonAttributes.MATCH),
    MAX_BACKUP_INDEX((AttributeDefinition)SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX),
    NAMED_FORMATTER((AttributeDefinition)AbstractHandlerDefinition.NAMED_FORMATTER),
    NOT((AttributeDefinition)CommonAttributes.NOT),
    OVERFLOW_ACTION((AttributeDefinition)AsyncHandlerResourceDefinition.OVERFLOW_ACTION),
    PATTERN_FORMATTER((AttributeDefinition)PatternFormatterResourceDefinition.PATTERN_FORMATTER),
    PERIODIC_ROTATING_FILE_HANDLER("periodic-rotating-file-handler"),
    PERIODIC_SIZE_ROTATING_FILE_HANDLER("periodic-size-rotating-file-handler"),
    PORT((AttributeDefinition)SyslogHandlerResourceDefinition.PORT),
    PROPERTIES((AttributeDefinition)CommonAttributes.PROPERTIES),
    PROPERTY("property"),
    PROTOCOL((AttributeDefinition)SocketHandlerResourceDefinition.PROTOCOL),
    QUEUE_LENGTH((AttributeDefinition)AsyncHandlerResourceDefinition.QUEUE_LENGTH),
    REPLACE((AttributeDefinition)CommonAttributes.REPLACE),
    ROOT_LOGGER("root-logger"),
    ROTATE_SIZE((AttributeDefinition)SizeRotatingHandlerResourceDefinition.ROTATE_SIZE),
    SERVER_ADDRESS((AttributeDefinition)SyslogHandlerResourceDefinition.SERVER_ADDRESS),
    SIZE_ROTATING_FILE_HANDLER("size-rotating-file-handler"),
    SUBHANDLERS((AttributeDefinition)AsyncHandlerResourceDefinition.SUBHANDLERS),
    SUFFIX((AttributeDefinition)PeriodicHandlerResourceDefinition.SUFFIX),
    SOCKET_HANDLER("socket-handler"),
    SYSLOG_FORMATTER((AttributeDefinition)SyslogHandlerResourceDefinition.SYSLOG_FORMATTER),
    SYSLOG_HANDLER("syslog-handler"),
    TARGET((AttributeDefinition)ConsoleHandlerResourceDefinition.TARGET),
    USE_DEPLOYMENT_LOGGING_CONFIG((AttributeDefinition)LoggingResourceDefinition.USE_DEPLOYMENT_LOGGING_CONFIG),
    XML_FORMATTER("xml-formatter");

    private final String name;
    private final AttributeDefinition definition;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
        this.definition = null;
    }

    private Element(AttributeDefinition definition) {
        this.name = definition.getXmlName();
        this.definition = definition;
    }

    public String getLocalName() {
        return this.name;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

