/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import org.jboss.as.jaxrs.JaxrsAnnotations;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.jaxrs.deployment.ResteasyDeploymentData;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrapClasses;

public class JaxrsScanningProcessor
implements DeploymentUnitProcessor {
    private static final DotName DECORATOR = DotName.createSimple((String)"javax.decorator.Decorator");
    public static final DotName APPLICATION = DotName.createSimple((String)Application.class.getName());
    private static final String ORG_APACHE_CXF = "org.apache.cxf";
    public static final Set<String> BOOT_CLASSES = new HashSet<String>();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Map deploymentData;
        DeploymentUnit parent;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
            return;
        }
        DeploymentUnit deploymentUnit2 = parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        if (deploymentUnit.getParent() == null) {
            deploymentData = Collections.synchronizedMap(new HashMap());
            deploymentUnit.putAttachment(JaxrsAttachments.ADDITIONAL_RESTEASY_DEPLOYMENT_DATA, (Object)deploymentData);
        } else {
            deploymentData = (Map)parent.getAttachment(JaxrsAttachments.ADDITIONAL_RESTEASY_DEPLOYMENT_DATA);
        }
        ModuleIdentifier moduleIdentifier = (ModuleIdentifier)deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER);
        ResteasyDeploymentData resteasyDeploymentData = new ResteasyDeploymentData();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        try {
            if (warMetaData == null) {
                resteasyDeploymentData.setScanAll(true);
                this.scan(deploymentUnit, (ClassLoader)module.getClassLoader(), resteasyDeploymentData);
                deploymentData.put(moduleIdentifier, resteasyDeploymentData);
            } else {
                this.scanWebDeployment(deploymentUnit, warMetaData.getMergedJBossWebMetaData(), (ClassLoader)module.getClassLoader(), resteasyDeploymentData);
                this.scan(deploymentUnit, (ClassLoader)module.getClassLoader(), resteasyDeploymentData);
                if (resteasyDeploymentData.getScannedResourceClasses().isEmpty() && !resteasyDeploymentData.isDispatcherCreated() && this.hasBootClasses(warMetaData.getMergedJBossWebMetaData())) {
                    this.checkOtherParams(deploymentUnit, warMetaData.getMergedJBossWebMetaData(), (ClassLoader)module.getClassLoader(), resteasyDeploymentData);
                }
            }
            deploymentUnit.putAttachment(JaxrsAttachments.RESTEASY_DEPLOYMENT_DATA, (Object)resteasyDeploymentData);
        }
        catch (ModuleLoadException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private void checkOtherParams(DeploymentUnit du, JBossWebMetaData webdata, ClassLoader classLoader, ResteasyDeploymentData resteasyDeploymentData) throws DeploymentUnitProcessingException {
        HashSet<String> appClazzList = new HashSet<String>();
        List contextParamList = webdata.getContextParams();
        if (contextParamList != null) {
            for (ParamValueMetaData param : contextParamList) {
                if (!"javax.ws.rs.core.Application".equals(param.getParamName())) continue;
                appClazzList.add(param.getParamValue());
            }
        }
        if (webdata.getServlets() != null) {
            for (ServletMetaData servlet : webdata.getServlets()) {
                List initParamList = servlet.getInitParam();
                if (initParamList == null) continue;
                for (ParamValueMetaData param : initParamList) {
                    if (!"javax.ws.rs.core.Application".equals(param.getParamName())) continue;
                    appClazzList.add(param.getParamValue());
                }
            }
        }
        this.processDeclaredApplicationClasses(du, appClazzList, webdata, classLoader, resteasyDeploymentData);
    }

    private void processDeclaredApplicationClasses(DeploymentUnit du, Set<String> appClazzList, JBossWebMetaData webdata, ClassLoader classLoader, ResteasyDeploymentData resteasyDeploymentData) throws DeploymentUnitProcessingException {
        CompositeIndex index = (CompositeIndex)du.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        List resources = index.getAnnotations(JaxrsAnnotations.PATH.getDotName());
        HashMap<String, ClassInfo> resourceMap = new HashMap<String, ClassInfo>(resources.size());
        if (resources != null) {
            for (AnnotationInstance a : resources) {
                if (!(a.target() instanceof ClassInfo)) continue;
                resourceMap.put(((ClassInfo)a.target()).name().toString(), (ClassInfo)a.target());
            }
        }
        for (String clazzName : appClazzList) {
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(clazzName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
            if (!Application.class.isAssignableFrom(clazz)) continue;
            try {
                Application appClazz = (Application)clazz.newInstance();
                Set declClazzs = appClazz.getClasses();
                Set declSingletons = appClazz.getSingletons();
                HashSet<Class> clazzSet = new HashSet<Class>();
                if (declClazzs != null) {
                    clazzSet.addAll(declClazzs);
                }
                if (declSingletons != null) {
                    for (Object obj : declSingletons) {
                        clazzSet.add((Class)obj);
                    }
                }
                Set<String> scannedResourceClasses = resteasyDeploymentData.getScannedResourceClasses();
                for (Class cClazz : clazzSet) {
                    ClassInfo info;
                    if (!cClazz.isAnnotationPresent(Path.class) || (info = (ClassInfo)resourceMap.get(cClazz.getName())) == null || info.annotationsMap().containsKey(DECORATOR) || Modifier.isInterface(info.flags())) continue;
                    scannedResourceClasses.add(info.name().toString());
                }
            }
            catch (Exception e) {
                JaxrsLogger.JAXRS_LOGGER.cannotLoadApplicationClass(e);
            }
        }
    }

    protected boolean hasBootClasses(JBossWebMetaData webdata) throws DeploymentUnitProcessingException {
        if (webdata.getServlets() != null) {
            for (ServletMetaData servlet : webdata.getServlets()) {
                String servletClass = servlet.getServletClass();
                if (!BOOT_CLASSES.contains(servletClass)) continue;
                return true;
            }
        }
        if (webdata.getFilters() != null) {
            for (FilterMetaData filter : webdata.getFilters()) {
                if (!BOOT_CLASSES.contains(filter.getFilterClass())) continue;
                return true;
            }
        }
        return false;
    }

    protected void scanWebDeployment(DeploymentUnit du, JBossWebMetaData webdata, ClassLoader classLoader, ResteasyDeploymentData resteasyDeploymentData) throws DeploymentUnitProcessingException {
        List contextParams;
        boolean hasBoot = this.hasBootClasses(webdata);
        resteasyDeploymentData.setBootClasses(hasBoot);
        Class<?> declaredApplicationClass = this.checkDeclaredApplicationClassAsServlet(webdata, classLoader);
        if (declaredApplicationClass != null) {
            resteasyDeploymentData.setDispatcherCreated(true);
            resteasyDeploymentData.setScanProviders(true);
            resteasyDeploymentData.setScanResources(true);
        }
        if (!hasBoot && !webdata.isMetadataComplete()) {
            resteasyDeploymentData.setScanAll(true);
            resteasyDeploymentData.setScanProviders(true);
            resteasyDeploymentData.setScanResources(true);
        }
        if ((contextParams = webdata.getContextParams()) != null) {
            for (ParamValueMetaData param : contextParams) {
                if (param.getParamName().equals("resteasy.scan")) {
                    resteasyDeploymentData.setScanAll(this.valueOf("resteasy.scan", param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.scan.providers")) {
                    resteasyDeploymentData.setScanProviders(this.valueOf("resteasy.scan.providers", param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.scan.resources")) {
                    resteasyDeploymentData.setScanResources(this.valueOf("resteasy.scan.resources", param.getParamValue()));
                    continue;
                }
                if (!param.getParamName().equals("resteasy.unwrapped.exceptions")) continue;
                resteasyDeploymentData.setUnwrappedExceptionsParameterSet(true);
            }
        }
    }

    protected void scan(DeploymentUnit du, ClassLoader classLoader, ResteasyDeploymentData resteasyDeploymentData) throws DeploymentUnitProcessingException, ModuleLoadException {
        ClassInfo info;
        CompositeIndex index = (CompositeIndex)du.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (!resteasyDeploymentData.shouldScan()) {
            return;
        }
        if (!resteasyDeploymentData.isDispatcherCreated()) {
            Set applicationClasses = index.getAllKnownSubclasses(APPLICATION);
            try {
                for (ClassInfo c : applicationClasses) {
                    if (Modifier.isAbstract(c.flags())) continue;
                    Class<?> scanned = classLoader.loadClass(c.name().toString());
                    resteasyDeploymentData.getScannedApplicationClasses().add(scanned);
                }
            }
            catch (ClassNotFoundException e) {
                throw JaxrsLogger.JAXRS_LOGGER.cannotLoadApplicationClass(e);
            }
        }
        List resources = null;
        List providers = null;
        if (resteasyDeploymentData.isScanResources()) {
            resources = index.getAnnotations(JaxrsAnnotations.PATH.getDotName());
        }
        if (resteasyDeploymentData.isScanProviders()) {
            providers = index.getAnnotations(JaxrsAnnotations.PROVIDER.getDotName());
        }
        if ((resources == null || resources.isEmpty()) && (providers == null || providers.isEmpty())) {
            return;
        }
        HashSet<ClassInfo> pathInterfaces = new HashSet<ClassInfo>();
        if (resources != null) {
            for (AnnotationInstance e : resources) {
                if (!(e.target() instanceof ClassInfo)) {
                    if (e.target() instanceof MethodInfo) continue;
                    JaxrsLogger.JAXRS_LOGGER.classOrMethodAnnotationNotFound("@Path", e.target());
                    continue;
                }
                info = (ClassInfo)e.target();
                if (info.name().toString().startsWith(ORG_APACHE_CXF) || info.annotationsMap().containsKey(DECORATOR)) continue;
                if (!Modifier.isInterface(info.flags())) {
                    resteasyDeploymentData.getScannedResourceClasses().add(info.name().toString());
                    continue;
                }
                pathInterfaces.add(info);
            }
        }
        if (providers != null) {
            for (AnnotationInstance e : providers) {
                if (e.target() instanceof ClassInfo) {
                    info = (ClassInfo)e.target();
                    if (info.name().toString().startsWith(ORG_APACHE_CXF) || info.annotationsMap().containsKey(DECORATOR) || Modifier.isInterface(info.flags())) continue;
                    resteasyDeploymentData.getScannedProviderClasses().add(info.name().toString());
                    continue;
                }
                JaxrsLogger.JAXRS_LOGGER.classAnnotationNotFound("@Provider", e.target());
            }
        }
        for (ClassInfo iface : pathInterfaces) {
            Set implementors = index.getAllKnownImplementors(iface.name());
            for (ClassInfo implementor : implementors) {
                if (implementor.name().toString().startsWith(ORG_APACHE_CXF) || implementor.annotationsMap().containsKey(DECORATOR)) continue;
                resteasyDeploymentData.getScannedResourceClasses().add(implementor.name().toString());
            }
        }
    }

    protected Class<?> checkDeclaredApplicationClassAsServlet(JBossWebMetaData webData, ClassLoader classLoader) throws DeploymentUnitProcessingException {
        if (webData.getServlets() == null) {
            return null;
        }
        for (ServletMetaData servlet : webData.getServlets()) {
            String servletClass = servlet.getServletClass();
            if (servletClass == null) continue;
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(servletClass);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
            if (!Application.class.isAssignableFrom(clazz)) continue;
            servlet.setServletClass(HttpServlet30Dispatcher.class.getName());
            servlet.setAsyncSupported(true);
            ParamValueMetaData param = new ParamValueMetaData();
            param.setParamName("javax.ws.rs.Application");
            param.setParamValue(servletClass);
            ArrayList<ParamValueMetaData> params = servlet.getInitParam();
            if (params == null) {
                params = new ArrayList<ParamValueMetaData>();
                servlet.setInitParam(params);
            }
            params.add(param);
            return clazz;
        }
        return null;
    }

    private boolean valueOf(String paramName, String value) throws DeploymentUnitProcessingException {
        if (value == null) {
            throw JaxrsLogger.JAXRS_LOGGER.invalidParamValue(paramName, value);
        }
        if (value.toLowerCase(Locale.ENGLISH).equals("true")) {
            return true;
        }
        if (value.toLowerCase(Locale.ENGLISH).equals("false")) {
            return false;
        }
        throw JaxrsLogger.JAXRS_LOGGER.invalidParamValue(paramName, value);
    }

    static {
        Collections.addAll(BOOT_CLASSES, ResteasyBootstrapClasses.BOOTSTRAP_CLASSES);
    }
}

