/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.InputAbstract;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.qpid.jms.JmsConnectionFactory;

@Command(name="transfer", description="Moves Messages from one destination towards another destination")
public class Transfer
extends InputAbstract {
    @Option(name={"--source-url"}, description="URL towards the broker. (default: Build URL from acceptors defined in the broker.xml or tcp://localhost:61616 if the default cannot be parsed)")
    protected String sourceURL = "tcp://localhost:61616";
    @Option(name={"--source-acceptor"}, description="Acceptor used to build URL towards the broker")
    protected String sourceAcceptor;
    @Option(name={"--source-user"}, description="User used to connect")
    protected String sourceUser;
    @Option(name={"--source-password"}, description="Password used to connect")
    protected String sourcePassword;
    @Option(name={"--target-url"}, description="URL towards the broker. (default: Read from current broker.xml or tcp://localhost:61616 if the default cannot be parsed)")
    protected String targetURL = "tcp://localhost:61616";
    @Option(name={"--target-user"}, description="User used to connect")
    protected String targetUser;
    @Option(name={"--target-password"}, description="Password used to connect")
    protected String targetPassword;
    @Option(name={"--receive-timeout"}, description="Amount of time (in milliseconds) to wait before giving up the loop. 0 means receiveNoWait, -1 means consumer.receive() waiting forever. (default=5000)")
    int receiveTimeout = 5000;
    @Option(name={"--source-client-id"}, description="ClientID to be associated with connection")
    String sourceClientID;
    @Option(name={"--source-protocol"}, description="Protocol used. Valid values are amqp or core. Default=core.")
    String sourceProtocol = "core";
    @Option(name={"--source-queue"}, description="JMS Queue to be used.")
    String sourceQueue;
    @Option(name={"--shared-durable-subscription"}, description="Name of a shared subscription name to be used on the input topic")
    String sharedDurableSubscription;
    @Option(name={"--shared-subscription"}, description="Name of a shared subscription name to be used on the input topic")
    String sharedSubscription;
    @Option(name={"--durable-consumer"}, description="Name of a durable consumer to be used on the input topic")
    String durableConsumer;
    @Option(name={"--no-Local"}, description="Use noLocal when applicable on topic operation")
    boolean noLocal;
    @Option(name={"--source-topic"}, description="Destination to be used. It can be prefixed with queue:// or topic:// and can be an FQQN in the form of <address>::<queue>. (Default: queue://TEST)")
    String sourceTopic;
    @Option(name={"--source-filter"}, description="filter to be used with the consumer")
    String filter;
    @Option(name={"--target-protocol"}, description="Protocol used. Valid values are amqp or core. Default=core.")
    String targetProtocol = "core";
    @Option(name={"--commit-interval"}, description="Transaction batch interval.")
    int commitInterval = 1000;
    @Option(name={"--copy"}, description="If this option is chosen we will perform a copy of the queue by rolling back the original TX on the source.")
    boolean copy;
    @Option(name={"--target-queue"}, description="JMS Queue to be used.")
    String targetQueue;
    @Option(name={"--target-topic"}, description="Destination to be used. It can be prefixed with queue:// or topic:// and can be an FQQN in the form of <address>::<queue>. (Default: queue://TEST)")
    String targetTopic;
    @Option(name={"--message-count"}, description="Number of messages to transfer.")
    int messageCount = Integer.MAX_VALUE;

    public String getSourceURL() {
        return this.sourceURL;
    }

    public Transfer setSourceURL(String sourceURL) {
        this.sourceURL = sourceURL;
        return this;
    }

    public String getSourceAcceptor() {
        return this.sourceAcceptor;
    }

    public Transfer setSourceAcceptor(String sourceAcceptor) {
        this.sourceAcceptor = sourceAcceptor;
        return this;
    }

    public String getSourceUser() {
        return this.sourceUser;
    }

    public Transfer setSourceUser(String sourceUser) {
        this.sourceUser = sourceUser;
        return this;
    }

    public String getSourcePassword() {
        return this.sourcePassword;
    }

    public Transfer setSourcePassword(String sourcePassword) {
        this.sourcePassword = sourcePassword;
        return this;
    }

    public String getTargetURL() {
        return this.targetURL;
    }

    public Transfer setTargetURL(String targetURL) {
        this.targetURL = targetURL;
        return this;
    }

    public String getTargetUser() {
        return this.targetUser;
    }

    public Transfer setTargetUser(String targetUser) {
        this.targetUser = targetUser;
        return this;
    }

    public String getTargetPassword() {
        return this.targetPassword;
    }

    public Transfer setTargetPassword(String targetPassword) {
        this.targetPassword = targetPassword;
        return this;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public Transfer setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
        return this;
    }

    public String getSourceClientID() {
        return this.sourceClientID;
    }

    public Transfer setSourceClientID(String sourceClientID) {
        this.sourceClientID = sourceClientID;
        return this;
    }

    public String getSourceProtocol() {
        return this.sourceProtocol;
    }

    public Transfer setSourceProtocol(String sourceProtocol) {
        this.sourceProtocol = sourceProtocol;
        return this;
    }

    public String getSourceQueue() {
        return this.sourceQueue;
    }

    public Transfer setSourceQueue(String sourceQueue) {
        this.sourceQueue = sourceQueue;
        return this;
    }

    public String getSharedDurableSubscription() {
        return this.sharedDurableSubscription;
    }

    public Transfer setSharedDurableSubscription(String sharedDurableSubscription) {
        this.sharedDurableSubscription = sharedDurableSubscription;
        return this;
    }

    public String getSharedSubscription() {
        return this.sharedSubscription;
    }

    public Transfer setSharedSubscription(String sharedSubscription) {
        this.sharedSubscription = sharedSubscription;
        return this;
    }

    public String getDurableConsumer() {
        return this.durableConsumer;
    }

    public Transfer setDurableConsumer(String durableConsumer) {
        this.durableConsumer = durableConsumer;
        return this;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public Transfer setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
        return this;
    }

    public String getSourceTopic() {
        return this.sourceTopic;
    }

    public Transfer setSourceTopic(String sourceTopic) {
        this.sourceTopic = sourceTopic;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public Transfer setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getTargetProtocol() {
        return this.targetProtocol;
    }

    public Transfer setTargetProtocol(String targetProtocol) {
        this.targetProtocol = targetProtocol;
        return this;
    }

    public int getCommitInterval() {
        return this.commitInterval;
    }

    public Transfer setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
        return this;
    }

    public boolean isCopy() {
        return this.copy;
    }

    public Transfer setCopy(boolean copy) {
        this.copy = copy;
        return this;
    }

    public String getTargetQueue() {
        return this.targetQueue;
    }

    public Transfer setTargetQueue(String targetQueue) {
        this.targetQueue = targetQueue;
        return this;
    }

    public String getTargetTopic() {
        return this.targetTopic;
    }

    public Transfer setTargetTopic(String targetTopic) {
        this.targetTopic = targetTopic;
        return this;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public Transfer setMessageCount(int messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        String brokerURLInstance;
        super.execute(context);
        if (this.sourceURL == "tcp://localhost:61616" && (brokerURLInstance = this.getBrokerURLInstance(this.sourceAcceptor)) != null) {
            this.sourceURL = brokerURLInstance;
        }
        System.out.println("Connection brokerURL = " + this.sourceURL);
        ConnectionFactory sourceConnectionFactory = this.createConnectionFactory("source", this.sourceProtocol, this.sourceURL, this.sourceUser, this.sourcePassword, this.sourceClientID);
        Connection sourceConnection = sourceConnectionFactory.createConnection();
        Session sourceSession = sourceConnection.createSession(0);
        Destination sourceDestination = this.createDestination("source", sourceSession, this.sourceQueue, this.sourceTopic);
        MessageConsumer consumer = null;
        if (sourceDestination instanceof Queue) {
            consumer = this.filter != null ? sourceSession.createConsumer(sourceDestination, this.filter) : sourceSession.createConsumer(sourceDestination);
        } else if (sourceDestination instanceof Topic) {
            Topic topic = (Topic)sourceDestination;
            if (this.durableConsumer != null) {
                consumer = this.filter != null ? sourceSession.createDurableConsumer(topic, this.durableConsumer) : sourceSession.createDurableConsumer(topic, this.durableConsumer, this.filter, this.noLocal);
            } else if (this.sharedDurableSubscription != null) {
                consumer = this.filter != null ? sourceSession.createSharedDurableConsumer(topic, this.sharedDurableSubscription, this.filter) : sourceSession.createSharedDurableConsumer(topic, this.sharedDurableSubscription);
            } else if (this.sharedSubscription != null) {
                consumer = this.filter != null ? sourceSession.createSharedConsumer(topic, this.sharedSubscription, this.filter) : sourceSession.createSharedConsumer(topic, this.sharedSubscription);
            } else {
                throw new IllegalArgumentException("you have to specify --durable-consumer, --shared-durable-subscription or --shared-subscription with a topic");
            }
        }
        ConnectionFactory targetConnectionFactory = this.createConnectionFactory("target", this.targetProtocol, this.targetURL, this.targetUser, this.targetPassword, null);
        Connection targetConnection = targetConnectionFactory.createConnection();
        Session targetSession = targetConnection.createSession(0);
        Destination targetDestination = this.createDestination("target", targetSession, this.targetQueue, this.targetTopic);
        MessageProducer producer = targetSession.createProducer(targetDestination);
        if (this.sourceURL.equals(this.targetURL) && sourceDestination.equals(targetDestination)) {
            System.out.println("You cannot transfer between " + this.sourceURL + "/" + sourceDestination + " and " + this.targetURL + "/" + targetDestination + ".\nThat would create an infinite recursion.");
            throw new IllegalArgumentException("cannot use " + sourceDestination + " == " + targetDestination);
        }
        sourceConnection.start();
        int pending = 0;
        int total = 0;
        while (total < this.messageCount) {
            Message receivedMessage = this.receiveTimeout < 0 ? consumer.receive() : (this.receiveTimeout == 0 ? consumer.receiveNoWait() : consumer.receive((long)this.receiveTimeout));
            if (receivedMessage == null) {
                if (!this.isVerbose()) break;
                System.out.println("could not receive any more messages");
                break;
            }
            producer.send(receivedMessage);
            ++pending;
            ++total;
            if (this.isVerbose()) {
                System.out.println("Received message " + total + " with " + pending + " messages pending to be commited");
            }
            if (pending <= this.commitInterval) continue;
            System.out.println("Transferred " + pending + " messages of " + total);
            pending = 0;
            targetSession.commit();
            if (this.isCopy()) continue;
            sourceSession.commit();
        }
        System.out.println("Transferred a total of " + total + " messages");
        if (pending != 0) {
            targetSession.commit();
            if (this.isCopy()) {
                sourceSession.rollback();
            } else {
                sourceSession.commit();
            }
        }
        sourceConnection.close();
        targetConnection.close();
        return total;
    }

    Destination createDestination(String role, Session session, String queue, String topic) throws Exception {
        if (queue != null && topic != null) {
            throw new IllegalArgumentException("Cannot have topic and queue passed as " + role);
        }
        if (queue != null) {
            return session.createQueue(queue);
        }
        if (topic != null) {
            return session.createTopic(topic);
        }
        throw new IllegalArgumentException("You need to pass either a topic or a queue as " + role);
    }

    protected ConnectionFactory createConnectionFactory(String role, String protocol, String brokerURL, String user, String password, String clientID) throws Exception {
        if (protocol.equals("core")) {
            if (this.isVerbose()) {
                System.out.println("Creating " + role + " CORE Connection towards " + brokerURL);
            }
            return this.createCoreConnectionFactory(brokerURL, user, password, clientID);
        }
        if (protocol.equals("amqp")) {
            if (this.isVerbose()) {
                System.out.println("Creating " + role + " AMQP Connection towards " + brokerURL);
            }
            return this.createAMQPConnectionFactory(brokerURL, user, password, clientID);
        }
        throw new IllegalStateException("protocol " + protocol + " not supported");
    }

    private ConnectionFactory createAMQPConnectionFactory(String brokerURL, String user, String password, String clientID) {
        if (((String)brokerURL).startsWith("tcp://")) {
            brokerURL = "amqp" + ((String)brokerURL).substring(3);
        }
        JmsConnectionFactory cf = new JmsConnectionFactory(user, password, (String)brokerURL);
        if (clientID != null) {
            cf.setClientID(clientID);
        }
        try {
            Connection connection = cf.createConnection();
            connection.close();
            return cf;
        }
        catch (JMSSecurityException e) {
            this.context.err.println("Connection failed::" + e.getMessage());
            this.userPassword((String)brokerURL);
            cf = new JmsConnectionFactory(user, password, (String)brokerURL);
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            return cf;
        }
        catch (JMSException e) {
            this.context.err.println("Connection failed::" + e.getMessage());
            brokerURL = this.input("--url", "Type in the broker URL for a retry (e.g. tcp://localhost:61616)", (String)brokerURL);
            this.userPassword((String)brokerURL);
            cf = new JmsConnectionFactory(user, password, (String)brokerURL);
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            return cf;
        }
    }

    protected ActiveMQConnectionFactory createCoreConnectionFactory(String brokerURL, String user, String password, String clientID) {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(brokerURL, user, password);
        if (clientID != null) {
            System.out.println("Consumer:: clientID = " + clientID);
            cf.setClientID(clientID);
        }
        try {
            Connection connection = cf.createConnection();
            connection.close();
            return cf;
        }
        catch (JMSSecurityException e) {
            if (this.context != null) {
                this.context.err.println("Connection failed::" + e.getMessage());
            }
            Pair<String, String> userPair = this.userPassword(brokerURL);
            cf = new ActiveMQConnectionFactory(brokerURL, (String)userPair.getA(), (String)userPair.getB());
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            return cf;
        }
        catch (JMSException e) {
            if (this.context != null) {
                this.context.err.println("Connection failed::" + e.getMessage());
            }
            brokerURL = this.input("--url", "Type in the broker URL for a retry (e.g. tcp://localhost:61616)", brokerURL);
            Pair<String, String> userPair = this.userPassword(brokerURL);
            cf = new ActiveMQConnectionFactory(brokerURL, (String)userPair.getA(), (String)userPair.getB());
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            return cf;
        }
    }

    Pair<String, String> userPassword(String uri) {
        System.out.println("Type in user/password towards " + uri);
        String user = this.input("--user", "Type the username for a retry", null);
        String password = this.inputPassword("--password", "Type the password for a retry", null);
        return new Pair((Object)user, (Object)password);
    }
}

