/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wsc11;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wscoor.CoordinationConstants;
import com.arjuna.webservices11.wscoor.client.ActivationCoordinatorClient;
import com.arjuna.wsc.InvalidCreateParametersException;
import jakarta.xml.soap.Detail;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContext;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CreateCoordinationContextResponseType;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.Expires;

public class ActivationCoordinator {
    public static CoordinationContextType createCoordinationContext(String activationCoordinatorURI, String messageID, String coordinationTypeURI, Long expires, CoordinationContext currentContext) throws InvalidCreateParametersException, SoapFault {
        Expires expiresValue;
        MAP map = AddressingHelper.createRequestContext(activationCoordinatorURI, messageID);
        if (expires == null) {
            expiresValue = null;
        } else {
            expiresValue = new Expires();
            expiresValue.setValue(expires);
        }
        try {
            ActivationCoordinatorClient client = ActivationCoordinatorClient.getClient();
            CreateCoordinationContextResponseType response = client.sendCreateCoordination(map, coordinationTypeURI, expiresValue, currentContext);
            return response.getCoordinationContext();
        }
        catch (IOException ioe) {
            throw new SoapFault11(ioe);
        }
        catch (SOAPFaultException sfe) {
            SOAPFault soapFault = sfe.getFault();
            QName subcode = soapFault.getFaultCodeAsQName();
            if (CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_PARAMETERS_QNAME.equals(subcode)) {
                Detail detail = soapFault.getDetail();
                String message = detail != null ? detail.getTextContent() : soapFault.getFaultString();
                throw new InvalidCreateParametersException(message);
            }
            throw SoapFault11.create(sfe);
        }
    }
}

