/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.message.Message;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class AmqpReceiverDispositionTest {

    public static class AmqpReceiverDispositionRejectAsUnmodifiedModeTests
    extends AmqpClientTestSupport {
        @Override
        protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
            params.put("amqpTreatRejectAsUnmodifiedDeliveryFailed", true);
        }

        @Test(timeout=30000L)
        public void testRejectedDisposition() throws Exception {
            this.sendMessages(this.getQueueName(), 1);
            AmqpClient client = this.createAmqpClient();
            AmqpConnection connection = this.addConnection(client.connect());
            AmqpSession session = connection.createSession();
            AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
            receiver1.flow(1);
            AmqpMessage message = receiver1.receive(5L, TimeUnit.SECONDS);
            AmqpReceiverDispositionRejectAsUnmodifiedModeTests.assertNotNull((String)"did not receive message first time", (Object)message);
            AmqpReceiverDispositionRejectAsUnmodifiedModeTests.assertEquals((Object)"MessageID:0", (Object)message.getMessageId());
            Message protonMessage = message.getWrappedMessage();
            AmqpReceiverDispositionRejectAsUnmodifiedModeTests.assertNotNull((Object)protonMessage);
            AmqpReceiverDispositionRejectAsUnmodifiedModeTests.assertEquals((String)"Unexpected initial value for AMQP delivery-count", (long)0L, (long)protonMessage.getDeliveryCount());
            message.reject();
            receiver1.flow(1);
            message = receiver1.receive(5L, TimeUnit.SECONDS);
            AmqpReceiverDispositionRejectAsUnmodifiedModeTests.assertNotNull((String)"did not receive message after reject", (Object)message);
            AmqpReceiverDispositionRejectAsUnmodifiedModeTests.assertEquals((Object)"MessageID:0", (Object)message.getMessageId());
            protonMessage = message.getWrappedMessage();
            AmqpReceiverDispositionRejectAsUnmodifiedModeTests.assertNotNull((Object)protonMessage);
            AmqpReceiverDispositionRejectAsUnmodifiedModeTests.assertEquals((String)"Unexpected value for AMQP delivery-count after redelivery", (long)1L, (long)protonMessage.getDeliveryCount());
            connection.close();
        }
    }

    public static class AmqpReceiverDispositionOrdinaryTests
    extends AmqpClientTestSupport {
        @Test(timeout=30000L)
        public void testReleasedDisposition() throws Exception {
            this.sendMessages(this.getQueueName(), 1);
            AmqpClient client = this.createAmqpClient();
            AmqpConnection connection = this.addConnection(client.connect());
            AmqpSession session = connection.createSession();
            AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
            receiver1.flow(1);
            AmqpMessage message = receiver1.receive(5L, TimeUnit.SECONDS);
            AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
            AmqpReceiverDispositionOrdinaryTests.assertNotNull((String)"did not receive message first time", (Object)message);
            AmqpReceiverDispositionOrdinaryTests.assertEquals((Object)"MessageID:0", (Object)message.getMessageId());
            Message protonMessage = message.getWrappedMessage();
            AmqpReceiverDispositionOrdinaryTests.assertNotNull((Object)protonMessage);
            AmqpReceiverDispositionOrdinaryTests.assertEquals((String)"Unexpected initial value for AMQP delivery-count", (long)0L, (long)protonMessage.getDeliveryCount());
            receiver2.flow(1);
            message.release();
            message = receiver2.receive(10L, TimeUnit.SECONDS);
            AmqpReceiverDispositionOrdinaryTests.assertNotNull((String)"did not receive message again", (Object)message);
            AmqpReceiverDispositionOrdinaryTests.assertEquals((Object)"MessageID:0", (Object)message.getMessageId());
            message.accept();
            protonMessage = message.getWrappedMessage();
            AmqpReceiverDispositionOrdinaryTests.assertNotNull((Object)protonMessage);
            AmqpReceiverDispositionOrdinaryTests.assertEquals((String)"Unexpected updated value for AMQP delivery-count", (long)0L, (long)protonMessage.getDeliveryCount());
            connection.close();
        }

        @Test(timeout=30000L)
        public void testRejectedDisposition() throws Exception {
            this.sendMessages(this.getQueueName(), 1);
            AmqpClient client = this.createAmqpClient();
            AmqpConnection connection = this.addConnection(client.connect());
            AmqpSession session = connection.createSession();
            AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
            receiver1.flow(1);
            AmqpMessage message = receiver1.receive(5L, TimeUnit.SECONDS);
            AmqpReceiverDispositionOrdinaryTests.assertNotNull((String)"did not receive message first time", (Object)message);
            AmqpReceiverDispositionOrdinaryTests.assertEquals((Object)"MessageID:0", (Object)message.getMessageId());
            Message protonMessage = message.getWrappedMessage();
            AmqpReceiverDispositionOrdinaryTests.assertNotNull((Object)protonMessage);
            AmqpReceiverDispositionOrdinaryTests.assertEquals((String)"Unexpected initial value for AMQP delivery-count", (long)0L, (long)protonMessage.getDeliveryCount());
            message.reject();
            receiver1.flow(1);
            message = receiver1.receiveNoWait();
            AmqpReceiverDispositionOrdinaryTests.assertNull((String)"Should not receive message again", (Object)message);
            AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
            receiver2.flow(1);
            AmqpReceiverDispositionOrdinaryTests.assertNull((Object)receiver2.receiveNoWait());
            connection.close();
        }

        @Test(timeout=30000L)
        public void testModifiedDispositionWithDeliveryFailedWithoutUndeliverableHereFieldsSet() throws Exception {
            this.doModifiedDispositionTestImpl(Boolean.TRUE, null);
        }

        @Test(timeout=30000L)
        public void testModifiedDispositionWithoutDeliveryFailedWithoutUndeliverableHereFieldsSet() throws Exception {
            this.doModifiedDispositionTestImpl(null, null);
        }

        @Test(timeout=30000L)
        public void testModifiedDispositionWithoutDeliveryFailedWithUndeliverableHereFieldsSet() throws Exception {
            this.doModifiedDispositionTestImpl(null, Boolean.TRUE);
        }

        @Test(timeout=30000L)
        public void testModifiedDispositionWithDeliveryFailedWithUndeliverableHereFieldsSet() throws Exception {
            this.doModifiedDispositionTestImpl(Boolean.TRUE, Boolean.TRUE);
        }

        private void doModifiedDispositionTestImpl(Boolean deliveryFailed, Boolean undeliverableHere) throws Exception {
            this.sendMessages(this.getQueueName(), 1);
            AmqpClient client = this.createAmqpClient();
            AmqpConnection connection = this.addConnection(client.connect());
            AmqpSession session = connection.createSession();
            AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
            receiver1.flow(1);
            AmqpMessage message = receiver1.receive(5L, TimeUnit.SECONDS);
            AmqpReceiverDispositionOrdinaryTests.assertNotNull((String)"did not receive message first time", (Object)message);
            Message protonMessage = message.getWrappedMessage();
            AmqpReceiverDispositionOrdinaryTests.assertNotNull((Object)protonMessage);
            AmqpReceiverDispositionOrdinaryTests.assertEquals((String)"Unexpected initial value for AMQP delivery-count", (long)0L, (long)protonMessage.getDeliveryCount());
            message.modified(deliveryFailed, undeliverableHere);
            if (Boolean.TRUE.equals(undeliverableHere)) {
                receiver1.flow(1);
                message = receiver1.receive(1L, TimeUnit.SECONDS);
                AmqpReceiverDispositionOrdinaryTests.assertNull((String)"Should not receive message again", (Object)message);
            }
            AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
            receiver2.flow(1);
            message = receiver2.receive(5L, TimeUnit.SECONDS);
            AmqpReceiverDispositionOrdinaryTests.assertNotNull((String)"did not receive message again", (Object)message);
            int expectedDeliveryCount = 0;
            if (Boolean.TRUE.equals(deliveryFailed)) {
                expectedDeliveryCount = 1;
            }
            message.accept();
            Message protonMessage2 = message.getWrappedMessage();
            AmqpReceiverDispositionOrdinaryTests.assertNotNull((Object)protonMessage2);
            AmqpReceiverDispositionOrdinaryTests.assertEquals((String)"Unexpected updated value for AMQP delivery-count", (long)expectedDeliveryCount, (long)protonMessage2.getDeliveryCount());
            connection.close();
        }
    }
}

