/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.jms.provider.amqp.message.AmqpDestinationHelper;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.junit.Test;

public class ClientDefinedMultiConsumerTest
extends AmqpClientTestSupport {
    SimpleString address = new SimpleString("testAddress");

    @Test(timeout=60000L)
    public void test2ConsumersOnSharedVolatileAddress() throws Exception {
        AddressInfo addressInfo = new AddressInfo(this.address);
        addressInfo.getRoutingTypes().add(RoutingType.MULTICAST);
        this.server.addAddressInfo(addressInfo);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect("myClientId"));
        AmqpSession session = connection.createSession();
        Source source = this.createSharedSource(TerminusDurability.NONE);
        AmqpReceiver receiver = session.createMulticastReceiver(source, "myReceiverID", "mySub");
        AmqpReceiver receiver2 = session.createMulticastReceiver(source, "myReceiverID", "mySub|2");
        receiver.flow(1);
        receiver2.flow(1);
        this.sendMessages(this.address.toString(), 2);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        amqpMessage = receiver2.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        ClientDefinedMultiConsumerTest.assertEquals((long)2L, (long)((QueueImpl)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub:shared-volatile")).getBindable()).getConsumerCount());
        receiver.close();
        ClientDefinedMultiConsumerTest.assertNotNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub:shared-volatile")));
        receiver2.close();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisfied() throws Exception {
                return ClientDefinedMultiConsumerTest.this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub:shared-volatile")) == null;
            }
        }, (long)1000L);
        connection.close();
    }

    @Test(timeout=60000L)
    public void test2ConsumersOnSharedVolatileAddressBrokerDefined() throws Exception {
        AddressInfo addressInfo = new AddressInfo(this.address);
        addressInfo.getRoutingTypes().add(RoutingType.MULTICAST);
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(new QueueConfiguration("myClientId.mySub:shared-volatile").setAddress(this.address).setAutoCreateAddress(Boolean.valueOf(false)));
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect("myClientId"));
        AmqpSession session = connection.createSession();
        Source source = this.createSharedSource(TerminusDurability.NONE);
        AmqpReceiver receiver = session.createMulticastReceiver(source, "myReceiverID", "mySub");
        AmqpReceiver receiver2 = session.createMulticastReceiver(source, "myReceiverID", "mySub|1");
        receiver.flow(1);
        receiver2.flow(1);
        this.sendMessages(this.address.toString(), 2);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        amqpMessage = receiver2.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        ClientDefinedMultiConsumerTest.assertEquals((long)2L, (long)((QueueImpl)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub:shared-volatile")).getBindable()).getConsumerCount());
        receiver.close();
        ClientDefinedMultiConsumerTest.assertNotNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub:shared-volatile")));
        receiver2.close();
        ClientDefinedMultiConsumerTest.assertNotNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub:shared-volatile")));
        connection.close();
    }

    @Test(timeout=60000L)
    public void test2ConsumersOnSharedVolatileAddressNoReceiverClose() throws Exception {
        AddressInfo addressInfo = new AddressInfo(this.address);
        addressInfo.getRoutingTypes().add(RoutingType.MULTICAST);
        this.server.addAddressInfo(addressInfo);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect("myClientId"));
        AmqpSession session = connection.createSession();
        Source source = this.createSharedSource(TerminusDurability.NONE);
        AmqpReceiver receiver = session.createMulticastReceiver(source, "myReceiverID", "mySub");
        AmqpReceiver receiver2 = session.createMulticastReceiver(source, "myReceiverID", "mySub|2");
        receiver.flow(1);
        receiver2.flow(1);
        this.sendMessages(this.address.toString(), 2);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        amqpMessage = receiver2.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        ClientDefinedMultiConsumerTest.assertEquals((long)2L, (long)((QueueImpl)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub:shared-volatile")).getBindable()).getConsumerCount());
        ClientDefinedMultiConsumerTest.assertNotNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub:shared-volatile")));
        connection.close();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisfied() throws Exception {
                return ClientDefinedMultiConsumerTest.this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub:shared-volatile")) == null;
            }
        }, (long)1000L);
    }

    @Test(timeout=60000L)
    public void test2ConsumersOnSharedVolatileAddressGlobal() throws Exception {
        AddressInfo addressInfo = new AddressInfo(this.address);
        addressInfo.getRoutingTypes().add(RoutingType.MULTICAST);
        this.server.addAddressInfo(addressInfo);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect(false));
        AmqpSession session = connection.createSession();
        Source source = this.createSharedGlobalSource(TerminusDurability.NONE);
        AmqpReceiver receiver = session.createMulticastReceiver(source, "myReceiverID", "mySub");
        AmqpReceiver receiver2 = session.createMulticastReceiver(source, "myReceiverID", "mySub|2");
        receiver.flow(1);
        receiver2.flow(1);
        this.sendMessages(this.address.toString(), 2);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        amqpMessage = receiver2.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        ClientDefinedMultiConsumerTest.assertEquals((long)2L, (long)((QueueImpl)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"mySub:shared-volatile:global")).getBindable()).getConsumerCount());
        receiver.close();
        ClientDefinedMultiConsumerTest.assertNotNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"mySub:shared-volatile:global")));
        receiver2.close();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisfied() throws Exception {
                return ClientDefinedMultiConsumerTest.this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"mySub:shared-volatile:global")) == null;
            }
        }, (long)1000L);
        connection.close();
    }

    @Test(timeout=60000L)
    public void test2ConsumersOnSharedDurableAddress() throws Exception {
        AddressInfo addressInfo = new AddressInfo(this.address);
        addressInfo.getRoutingTypes().add(RoutingType.MULTICAST);
        this.server.addAddressInfo(addressInfo);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect("myClientId"));
        AmqpSession session = connection.createSession();
        Source source = this.createSharedSource(TerminusDurability.CONFIGURATION);
        AmqpReceiver receiver = session.createMulticastReceiver(source, "myReceiverID", "mySub");
        AmqpReceiver receiver2 = session.createMulticastReceiver(source, "myReceiverID", "mySub|2");
        receiver.flow(1);
        receiver2.flow(1);
        this.sendMessages(this.address.toString(), 2);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        amqpMessage = receiver2.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        ClientDefinedMultiConsumerTest.assertEquals((long)2L, (long)((QueueImpl)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub")).getBindable()).getConsumerCount());
        receiver.close();
        ClientDefinedMultiConsumerTest.assertNotNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub")));
        receiver2.close();
        ClientDefinedMultiConsumerTest.assertNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub")));
        connection.close();
    }

    @Test(timeout=60000L)
    public void test2ConsumersOnSharedDurableAddressReconnect() throws Exception {
        AddressInfo addressInfo = new AddressInfo(this.address);
        addressInfo.getRoutingTypes().add(RoutingType.MULTICAST);
        this.server.addAddressInfo(addressInfo);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect("myClientId"));
        AmqpSession session = connection.createSession();
        Source source = this.createSharedSource(TerminusDurability.CONFIGURATION);
        AmqpReceiver receiver = session.createMulticastReceiver(source, "myReceiverID", "mySub");
        AmqpReceiver receiver2 = session.createMulticastReceiver(source, "myReceiverID", "mySub|2");
        receiver.flow(1);
        receiver2.flow(1);
        this.sendMessages(this.address.toString(), 2);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        amqpMessage = receiver2.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        ClientDefinedMultiConsumerTest.assertEquals((long)2L, (long)((QueueImpl)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub")).getBindable()).getConsumerCount());
        connection.close();
        connection = this.addConnection(client.connect("myClientId"));
        session = connection.createSession();
        ClientDefinedMultiConsumerTest.assertNotNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub")));
        receiver = session.createMulticastReceiver(source, "myReceiverID", "mySub");
        receiver2 = session.createMulticastReceiver(source, "myReceiverID", "mySub|2");
        receiver.close();
        ClientDefinedMultiConsumerTest.assertNotNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub")));
        receiver2.close();
        ClientDefinedMultiConsumerTest.assertNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub")));
        connection.close();
    }

    @Test(timeout=60000L)
    public void test2ConsumersOnSharedDurableAddressReconnectwithNull() throws Exception {
        AddressInfo addressInfo = new AddressInfo(this.address);
        addressInfo.getRoutingTypes().add(RoutingType.MULTICAST);
        this.server.addAddressInfo(addressInfo);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect("myClientId"));
        AmqpSession session = connection.createSession();
        Source source = this.createSharedSource(TerminusDurability.CONFIGURATION);
        AmqpReceiver receiver = session.createMulticastReceiver(source, "myReceiverID", "mySub");
        AmqpReceiver receiver2 = session.createMulticastReceiver(source, "myReceiverID", "mySub|2");
        receiver.flow(1);
        receiver2.flow(1);
        this.sendMessages(this.address.toString(), 2);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        amqpMessage = receiver2.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        ClientDefinedMultiConsumerTest.assertEquals((long)2L, (long)((QueueImpl)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub")).getBindable()).getConsumerCount());
        connection.close();
        connection = this.addConnection(client.connect("myClientId"));
        session = connection.createSession();
        ClientDefinedMultiConsumerTest.assertNotNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub")));
        receiver = session.createDurableReceiver(null, "mySub");
        receiver2 = session.createDurableReceiver(null, "mySub|2");
        receiver.close();
        ClientDefinedMultiConsumerTest.assertNotNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub")));
        receiver2.close();
        ClientDefinedMultiConsumerTest.assertNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"myClientId.mySub")));
        connection.close();
    }

    @Test(timeout=60000L)
    public void test2ConsumersOnSharedDurableAddressGlobal() throws Exception {
        AddressInfo addressInfo = new AddressInfo(this.address);
        addressInfo.getRoutingTypes().add(RoutingType.MULTICAST);
        this.server.addAddressInfo(addressInfo);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect(false));
        AmqpSession session = connection.createSession();
        Source source = this.createSharedGlobalSource(TerminusDurability.CONFIGURATION);
        AmqpReceiver receiver = session.createMulticastReceiver(source, "myReceiverID", "mySub");
        AmqpReceiver receiver2 = session.createMulticastReceiver(source, "myReceiverID", "mySub|2");
        receiver.flow(1);
        receiver2.flow(1);
        this.sendMessages(this.address.toString(), 2);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        amqpMessage = receiver2.receive(5L, TimeUnit.SECONDS);
        ClientDefinedMultiConsumerTest.assertNotNull((Object)amqpMessage);
        ClientDefinedMultiConsumerTest.assertEquals((long)2L, (long)((QueueImpl)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"mySub:global")).getBindable()).getConsumerCount());
        receiver.close();
        ClientDefinedMultiConsumerTest.assertNotNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"mySub:global")));
        receiver2.close();
        ClientDefinedMultiConsumerTest.assertNull((Object)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)"mySub:global")));
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void test2ConsumersOnNonSharedDurableAddress() throws Exception {
        AddressInfo addressInfo = new AddressInfo(this.address);
        addressInfo.getRoutingTypes().add(RoutingType.MULTICAST);
        this.server.addAddressInfo(addressInfo);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect("myClientId"));
        AmqpSession session = connection.createSession();
        Source source = this.createNonSharedSource(TerminusDurability.CONFIGURATION);
        Source source1 = this.createSharedSource(TerminusDurability.CONFIGURATION);
        try (AmqpReceiver receiver = session.createMulticastReceiver(source, "myReceiverID", "mySub");){
            session.createMulticastReceiver(source1, "myReceiverID", "mySub|2");
            ClientDefinedMultiConsumerTest.fail((String)"Exception expected");
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAddressDoesntExist() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect("myClientId"));
        AmqpSession session = connection.createSession();
        Source source = this.createNonSharedSource(TerminusDurability.CONFIGURATION);
        Source source1 = this.createSharedSource(TerminusDurability.CONFIGURATION);
        try (AmqpReceiver receiver = session.createMulticastReceiver(source, "myReceiverID", "mySub");){
            session.createMulticastReceiver(source1, "myReceiverID", "mySub|2");
            ClientDefinedMultiConsumerTest.fail((String)"Exception expected");
        }
        connection.close();
    }

    private Source createNonSharedSource(TerminusDurability terminusDurability) {
        Source source = new Source();
        source.setAddress(this.address.toString());
        source.setCapabilities(new Symbol[]{AmqpDestinationHelper.TOPIC_CAPABILITY});
        source.setDurable(terminusDurability);
        return source;
    }

    private Source createSharedSource(TerminusDurability terminusDurability) {
        Source source = new Source();
        source.setAddress(this.address.toString());
        source.setCapabilities(new Symbol[]{AmqpDestinationHelper.TOPIC_CAPABILITY, SHARED});
        source.setDurable(terminusDurability);
        return source;
    }

    private Source createSharedGlobalSource(TerminusDurability terminusDurability) {
        Source source = new Source();
        source.setAddress(this.address.toString());
        source.setCapabilities(new Symbol[]{AmqpDestinationHelper.TOPIC_CAPABILITY, SHARED, GLOBAL});
        source.setDurable(terminusDurability);
        return source;
    }
}

